/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Brightness3: ImageVector
    get() {
        if (_brightness3 != null) {
            return _brightness3!!
        }
        _brightness3 = materialIcon(name = "TwoTone.Brightness3") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.7f, 4.91f)
                curveToRelative(1.46f, 2.0f, 2.3f, 4.46f, 2.3f, 7.09f)
                reflectiveCurveToRelative(-0.84f, 5.09f, -2.3f, 7.09f)
                curveTo(15.25f, 17.76f, 17.0f, 15.08f, 17.0f, 12.0f)
                reflectiveCurveToRelative(-1.75f, -5.76f, -4.3f, -7.09f)
                close()
            }
            materialPath {
                moveTo(9.0f, 2.0f)
                curveToRelative(-1.05f, 0.0f, -2.05f, 0.16f, -3.0f, 0.46f)
                curveToRelative(4.06f, 1.27f, 7.0f, 5.06f, 7.0f, 9.54f)
                curveToRelative(0.0f, 4.48f, -2.94f, 8.27f, -7.0f, 9.54f)
                curveToRelative(0.95f, 0.3f, 1.95f, 0.46f, 3.0f, 0.46f)
                curveToRelative(5.52f, 0.0f, 10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(14.52f, 2.0f, 9.0f, 2.0f)
                close()
                moveTo(12.7f, 19.09f)
                curveToRelative(1.46f, -2.0f, 2.3f, -4.46f, 2.3f, -7.09f)
                reflectiveCurveToRelative(-0.84f, -5.09f, -2.3f, -7.09f)
                curveTo(15.25f, 6.24f, 17.0f, 8.92f, 17.0f, 12.0f)
                reflectiveCurveToRelative(-1.75f, 5.76f, -4.3f, 7.09f)
                close()
            }
        }
        return _brightness3!!
    }

private var _brightness3: ImageVector? = null
