/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CommentsDisabled: ImageVector
    get() {
        if (_commentsDisabled != null) {
            return _commentsDisabled!!
        }
        _commentsDisabled = materialIcon(name = "TwoTone.CommentsDisabled") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.83f, 4.0f)
                horizontalLineTo(20.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(-1.17f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.17f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(-6.17f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(8.83f)
                lineTo(6.83f, 4.0f)
                close()
                moveTo(13.17f, 16.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.17f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(0.17f)
                lineTo(4.0f, 6.83f)
                verticalLineTo(16.0f)
                horizontalLineTo(13.17f)
                close()
            }
            materialPath {
                moveTo(18.83f, 16.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(6.83f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(20.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                lineToRelative(0.0f, 15.17f)
                lineTo(18.83f, 16.0f)
                close()
                moveTo(18.0f, 6.0f)
                horizontalLineTo(8.83f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(18.0f, 9.0f)
                horizontalLineToRelative(-6.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(18.0f, 14.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(18.0f)
                close()
                moveTo(21.9f, 21.9f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(15.17f, 18.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(4.83f)
                lineTo(0.69f, 3.51f)
                lineTo(2.1f, 2.1f)
                lineTo(21.9f, 21.9f)
                close()
                moveTo(13.17f, 16.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.17f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(0.17f)
                lineTo(4.0f, 6.83f)
                verticalLineTo(16.0f)
                horizontalLineTo(13.17f)
                close()
            }
        }
        return _commentsDisabled!!
    }

private var _commentsDisabled: ImageVector? = null
