/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FontDownloadOff: ImageVector
    get() {
        if (_fontDownloadOff != null) {
            return _fontDownloadOff!!
        }
        _fontDownloadOff = materialIcon(name = "TwoTone.FontDownloadOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.35f, 7.52f)
                lineTo(10.92f, 6.0f)
                horizontalLineToRelative(2.14f)
                lineToRelative(2.55f, 6.79f)
                lineTo(20.0f, 17.17f)
                verticalLineTo(4.0f)
                horizontalLineTo(6.83f)
                lineTo(10.35f, 7.52f)
                close()
                moveTo(12.58f, 9.75f)
                lineToRelative(-0.54f, -1.52f)
                horizontalLineToRelative(-0.1f)
                lineToRelative(-0.23f, 0.66f)
                lineTo(12.58f, 9.75f)
                close()
                moveTo(17.17f, 20.0f)
                lineToRelative(-5.07f, -5.07f)
                horizontalLineTo(9.58f)
                lineTo(8.49f, 18.0f)
                horizontalLineTo(6.41f)
                lineToRelative(2.39f, -6.37f)
                lineTo(4.0f, 6.83f)
                verticalLineTo(20.0f)
                horizontalLineTo(17.17f)
                close()
            }
            materialPath {
                moveTo(4.83f, 2.0f)
                horizontalLineTo(20.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(15.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(6.83f)
                lineTo(4.83f, 2.0f)
                close()
                moveTo(10.92f, 6.0f)
                lineToRelative(-0.57f, 1.52f)
                lineToRelative(1.36f, 1.36f)
                lineToRelative(0.23f, -0.66f)
                horizontalLineToRelative(0.1f)
                lineToRelative(0.54f, 1.52f)
                lineToRelative(3.04f, 3.04f)
                lineTo(13.07f, 6.0f)
                horizontalLineTo(10.92f)
                close()
                moveTo(20.49f, 23.31f)
                lineTo(19.17f, 22.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(4.83f)
                lineTo(0.69f, 3.51f)
                lineTo(2.1f, 2.1f)
                lineToRelative(19.8f, 19.8f)
                lineTo(20.49f, 23.31f)
                close()
                moveTo(17.17f, 20.0f)
                lineToRelative(-5.07f, -5.07f)
                horizontalLineTo(9.58f)
                lineTo(8.49f, 18.0f)
                horizontalLineTo(6.41f)
                lineToRelative(2.39f, -6.37f)
                lineTo(4.0f, 6.83f)
                verticalLineTo(20.0f)
                horizontalLineTo(17.17f)
                close()
            }
        }
        return _fontDownloadOff!!
    }

private var _fontDownloadOff: ImageVector? = null
