/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.KebabDining: ImageVector
    get() {
        if (_kebabDining != null) {
            return _kebabDining!!
        }
        _kebabDining = materialIcon(name = "TwoTone.KebabDining") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.5f, 5.0f)
                curveTo(15.22f, 5.0f, 15.0f, 4.78f, 15.0f, 4.5f)
                reflectiveCurveTo(15.22f, 4.0f, 15.5f, 4.0f)
                horizontalLineToRelative(3.0f)
                curveTo(18.78f, 4.0f, 19.0f, 4.22f, 19.0f, 4.5f)
                reflectiveCurveTo(18.78f, 5.0f, 18.5f, 5.0f)
                horizontalLineTo(15.5f)
                close()
                moveTo(18.5f, 16.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                reflectiveCurveTo(18.78f, 17.0f, 18.5f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                reflectiveCurveToRelative(0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineTo(18.5f)
                close()
                moveTo(19.0f, 10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(19.0f)
                close()
                moveTo(5.5f, 5.0f)
                curveTo(5.22f, 5.0f, 5.0f, 4.78f, 5.0f, 4.5f)
                reflectiveCurveTo(5.22f, 4.0f, 5.5f, 4.0f)
                horizontalLineToRelative(3.0f)
                curveTo(8.78f, 4.0f, 9.0f, 4.22f, 9.0f, 4.5f)
                reflectiveCurveTo(8.78f, 5.0f, 8.5f, 5.0f)
                horizontalLineTo(5.5f)
                close()
                moveTo(8.5f, 16.0f)
                curveTo(8.78f, 16.0f, 9.0f, 16.22f, 9.0f, 16.5f)
                reflectiveCurveTo(8.78f, 17.0f, 8.5f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(5.22f, 17.0f, 5.0f, 16.78f, 5.0f, 16.5f)
                reflectiveCurveTo(5.22f, 16.0f, 5.5f, 16.0f)
                horizontalLineTo(8.5f)
                close()
                moveTo(9.0f, 10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(9.0f)
                close()
            }
            materialPath {
                moveTo(17.75f, 7.0f)
                horizontalLineToRelative(0.75f)
                curveTo(19.88f, 7.0f, 21.0f, 5.88f, 21.0f, 4.5f)
                curveTo(21.0f, 3.12f, 19.88f, 2.0f, 18.5f, 2.0f)
                horizontalLineToRelative(-0.75f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(15.5f)
                curveTo(14.12f, 2.0f, 13.0f, 3.12f, 13.0f, 4.5f)
                curveTo(13.0f, 5.88f, 14.12f, 7.0f, 15.5f, 7.0f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(3.25f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(15.5f)
                curveToRelative(-1.38f, 0.0f, -2.5f, 1.12f, -2.5f, 2.5f)
                curveToRelative(0.0f, 1.38f, 1.12f, 2.5f, 2.5f, 2.5f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(0.75f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveToRelative(0.0f, -1.38f, -1.12f, -2.5f, -2.5f, -2.5f)
                horizontalLineToRelative(-0.75f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(21.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-3.25f)
                verticalLineTo(7.0f)
                close()
                moveTo(15.5f, 5.0f)
                curveTo(15.22f, 5.0f, 15.0f, 4.78f, 15.0f, 4.5f)
                reflectiveCurveTo(15.22f, 4.0f, 15.5f, 4.0f)
                horizontalLineToRelative(3.0f)
                curveTo(18.78f, 4.0f, 19.0f, 4.22f, 19.0f, 4.5f)
                reflectiveCurveTo(18.78f, 5.0f, 18.5f, 5.0f)
                horizontalLineTo(15.5f)
                close()
                moveTo(18.5f, 16.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                reflectiveCurveTo(18.78f, 17.0f, 18.5f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                reflectiveCurveToRelative(0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineTo(18.5f)
                close()
                moveTo(19.0f, 10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(19.0f)
                close()
                moveTo(7.75f, 7.0f)
                horizontalLineTo(8.5f)
                curveTo(9.88f, 7.0f, 11.0f, 5.88f, 11.0f, 4.5f)
                curveTo(11.0f, 3.12f, 9.88f, 2.0f, 8.5f, 2.0f)
                horizontalLineTo(7.75f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.5f)
                curveTo(4.12f, 2.0f, 3.0f, 3.12f, 3.0f, 4.5f)
                curveTo(3.0f, 5.88f, 4.12f, 7.0f, 5.5f, 7.0f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(3.25f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.5f)
                curveTo(4.12f, 14.0f, 3.0f, 15.12f, 3.0f, 16.5f)
                curveTo(3.0f, 17.88f, 4.12f, 19.0f, 5.5f, 19.0f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(8.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveToRelative(0.0f, -1.38f, -1.12f, -2.5f, -2.5f, -2.5f)
                horizontalLineTo(7.75f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(7.75f)
                verticalLineTo(7.0f)
                close()
                moveTo(5.5f, 5.0f)
                curveTo(5.22f, 5.0f, 5.0f, 4.78f, 5.0f, 4.5f)
                reflectiveCurveTo(5.22f, 4.0f, 5.5f, 4.0f)
                horizontalLineToRelative(3.0f)
                curveTo(8.78f, 4.0f, 9.0f, 4.22f, 9.0f, 4.5f)
                reflectiveCurveTo(8.78f, 5.0f, 8.5f, 5.0f)
                horizontalLineTo(5.5f)
                close()
                moveTo(8.5f, 16.0f)
                curveTo(8.78f, 16.0f, 9.0f, 16.22f, 9.0f, 16.5f)
                reflectiveCurveTo(8.78f, 17.0f, 8.5f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(5.22f, 17.0f, 5.0f, 16.78f, 5.0f, 16.5f)
                reflectiveCurveTo(5.22f, 16.0f, 5.5f, 16.0f)
                horizontalLineTo(8.5f)
                close()
                moveTo(9.0f, 10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(9.0f)
                close()
            }
        }
        return _kebabDining!!
    }

private var _kebabDining: ImageVector? = null
