/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SensorOccupied: ImageVector
    get() {
        if (_sensorOccupied != null) {
            return _sensorOccupied!!
        }
        _sensorOccupied = materialIcon(name = "TwoTone.SensorOccupied") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.14f, 15.0f)
                horizontalLineToRelative(7.7f)
                curveToRelative(-1.16f, -0.65f, -2.5f, -1.0f, -3.85f, -1.0f)
                curveTo(10.65f, 14.0f, 9.32f, 14.35f, 8.14f, 15.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 8.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 11.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 6.34f, 9.0f, 8.0f)
                reflectiveCurveTo(10.34f, 11.0f, 12.0f, 11.0f)
                close()
                moveTo(12.0f, 7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(11.45f, 7.0f, 12.0f, 7.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                curveToRelative(-1.84f, 0.0f, -3.56f, 0.5f, -5.03f, 1.37f)
                curveTo(6.36f, 13.72f, 6.0f, 14.39f, 6.0f, 15.09f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.91f)
                curveToRelative(0.0f, -0.7f, -0.36f, -1.36f, -0.97f, -1.72f)
                curveTo(15.56f, 12.5f, 13.84f, 12.0f, 12.0f, 12.0f)
                close()
                moveTo(8.14f, 15.0f)
                curveToRelative(1.18f, -0.65f, 2.51f, -1.0f, 3.86f, -1.0f)
                curveToRelative(1.35f, 0.0f, 2.68f, 0.35f, 3.85f, 1.0f)
                horizontalLineTo(8.14f)
                close()
            }
            materialPath {
                moveTo(21.23f, 8.15f)
                lineToRelative(1.85f, -0.77f)
                curveToRelative(-1.22f, -2.91f, -3.55f, -5.25f, -6.46f, -6.46f)
                lineToRelative(-0.77f, 1.85f)
                curveTo(18.27f, 3.79f, 20.21f, 5.73f, 21.23f, 8.15f)
                close()
            }
            materialPath {
                moveTo(8.15f, 2.77f)
                lineTo(7.38f, 0.92f)
                curveTo(4.47f, 2.14f, 2.14f, 4.47f, 0.92f, 7.38f)
                lineToRelative(1.85f, 0.77f)
                curveTo(3.79f, 5.73f, 5.73f, 3.79f, 8.15f, 2.77f)
                close()
            }
            materialPath {
                moveTo(2.77f, 15.85f)
                lineToRelative(-1.85f, 0.77f)
                curveToRelative(1.22f, 2.91f, 3.55f, 5.25f, 6.46f, 6.46f)
                lineToRelative(0.77f, -1.85f)
                curveTo(5.73f, 20.21f, 3.79f, 18.27f, 2.77f, 15.85f)
                close()
            }
            materialPath {
                moveTo(15.85f, 21.23f)
                lineToRelative(0.77f, 1.85f)
                curveToRelative(2.91f, -1.22f, 5.25f, -3.55f, 6.46f, -6.46f)
                lineToRelative(-1.85f, -0.77f)
                curveTo(20.21f, 18.27f, 18.27f, 20.21f, 15.85f, 21.23f)
                close()
            }
        }
        return _sensorOccupied!!
    }

private var _sensorOccupied: ImageVector? = null
