/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Houseboat: ImageVector
    get() {
        if (_houseboat != null) {
            return _houseboat!!
        }
        _houseboat = materialIcon(name = "Filled.Houseboat") {
            materialPath {
                moveTo(12.0f, 16.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveTo(3.38f, 16.0f, 3.24f, 17.0f, 2.0f, 17.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(1.9f, 0.0f, 2.17f, -1.0f, 3.35f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.08f, -1.0f, 3.32f, -1.0f)
                reflectiveCurveToRelative(1.37f, 1.0f, 3.32f, 1.0f)
                curveToRelative(1.91f, 0.0f, 2.14f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.18f, 0.0f, 1.45f, 1.0f, 3.35f, 1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-1.24f, 0.0f, -1.38f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.91f, 0.0f, -2.14f, 1.0f, -3.33f, 1.0f)
                curveTo(14.1f, 17.0f, 13.95f, 16.0f, 12.0f, 16.0f)
                close()
                moveTo(20.34f, 11.34f)
                lineToRelative(-1.37f, 1.37f)
                curveTo(18.78f, 12.89f, 18.52f, 13.0f, 18.26f, 13.0f)
                horizontalLineTo(17.0f)
                verticalLineTo(9.65f)
                lineToRelative(1.32f, 0.97f)
                lineTo(19.5f, 9.0f)
                lineTo(12.0f, 3.5f)
                lineTo(4.5f, 9.0f)
                lineToRelative(1.18f, 1.61f)
                lineTo(7.0f, 9.65f)
                verticalLineTo(13.0f)
                horizontalLineTo(5.74f)
                curveToRelative(-0.27f, 0.0f, -0.52f, -0.11f, -0.71f, -0.29f)
                lineToRelative(-1.37f, -1.37f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(1.37f, 1.37f)
                curveTo(4.18f, 14.68f, 4.95f, 15.0f, 5.74f, 15.0f)
                horizontalLineToRelative(12.51f)
                curveToRelative(0.8f, 0.0f, 1.56f, -0.32f, 2.12f, -0.88f)
                lineToRelative(1.37f, -1.37f)
                lineTo(20.34f, 11.34f)
                close()
                moveTo(13.0f, 13.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(13.0f)
                close()
            }
        }
        return _houseboat!!
    }

private var _houseboat: ImageVector? = null
