/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Vrpano: ImageVector
    get() {
        if (_vrpano != null) {
            return _vrpano!!
        }
        _vrpano = materialIcon(name = "Filled.Vrpano") {
            materialPath {
                moveTo(20.69f, 4.05f)
                curveTo(18.66f, 4.73f, 15.86f, 5.5f, 12.0f, 5.5f)
                curveToRelative(-3.89f, 0.0f, -6.95f, -0.84f, -8.69f, -1.43f)
                curveTo(2.67f, 3.85f, 2.0f, 4.33f, 2.0f, 5.02f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 0.68f, 0.66f, 1.17f, 1.31f, 0.95f)
                curveTo(5.36f, 19.26f, 8.1f, 18.5f, 12.0f, 18.5f)
                curveToRelative(3.87f, 0.0f, 6.66f, 0.76f, 8.69f, 1.45f)
                curveTo(21.34f, 20.16f, 22.0f, 19.68f, 22.0f, 19.0f)
                verticalLineTo(5.0f)
                curveTo(22.0f, 4.32f, 21.34f, 3.84f, 20.69f, 4.05f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-2.34f, 0.0f, -4.52f, 0.15f, -6.52f, 0.41f)
                lineToRelative(3.69f, -4.42f)
                lineToRelative(2.0f, 2.4f)
                lineTo(14.0f, 10.0f)
                lineToRelative(4.51f, 5.4f)
                curveTo(16.52f, 15.15f, 14.3f, 15.0f, 12.0f, 15.0f)
                close()
            }
        }
        return _vrpano!!
    }

private var _vrpano: ImageVector? = null
