/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.WrongLocation: ImageVector
    get() {
        if (_wrongLocation != null) {
            return _wrongLocation!!
        }
        _wrongLocation = materialIcon(name = "Filled.WrongLocation") {
            materialPath {
                moveTo(14.0f, 10.0f)
                verticalLineTo(3.26f)
                curveTo(13.35f, 3.09f, 12.68f, 3.0f, 12.0f, 3.0f)
                curveToRelative(-4.2f, 0.0f, -8.0f, 3.22f, -8.0f, 8.2f)
                curveToRelative(0.0f, 3.32f, 2.67f, 7.25f, 8.0f, 11.8f)
                curveToRelative(5.33f, -4.55f, 8.0f, -8.48f, 8.0f, -11.8f)
                curveToRelative(0.0f, -0.41f, -0.04f, -0.81f, -0.09f, -1.2f)
                horizontalLineTo(14.0f)
                close()
                moveTo(12.0f, 13.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(14.0f, 12.1f, 13.1f, 13.0f, 12.0f, 13.0f)
                close()
            }
            materialPath {
                moveTo(22.54f, 2.88f)
                lineToRelative(-1.42f, -1.42f)
                lineToRelative(-2.12f, 2.13f)
                lineToRelative(-2.12f, -2.13f)
                lineToRelative(-1.42f, 1.42f)
                lineToRelative(2.13f, 2.12f)
                lineToRelative(-2.13f, 2.12f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(2.12f, -2.13f)
                lineToRelative(2.12f, 2.13f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(-2.13f, -2.12f)
                close()
            }
        }
        return _wrongLocation!!
    }

private var _wrongLocation: ImageVector? = null
