/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Details: ImageVector
    get() {
        if (_details != null) {
            return _details!!
        }
        _details = materialIcon(name = "Outlined.Details") {
            materialPath {
                moveTo(12.0f, 3.0f)
                lineTo(2.0f, 21.0f)
                horizontalLineToRelative(20.0f)
                lineTo(12.0f, 3.0f)
                close()
                moveTo(13.0f, 8.92f)
                lineTo(18.6f, 19.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(8.92f)
                close()
                moveTo(11.0f, 8.92f)
                verticalLineTo(19.0f)
                horizontalLineTo(5.4f)
                lineTo(11.0f, 8.92f)
                close()
            }
        }
        return _details!!
    }

private var _details: ImageVector? = null
