/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.HomeWork: ImageVector
    get() {
        if (_homeWork != null) {
            return _homeWork!!
        }
        _homeWork = materialIcon(name = "Outlined.HomeWork") {
            materialPath {
                moveTo(1.0f, 11.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(11.0f)
                lineTo(8.0f, 6.0f)
                lineTo(1.0f, 11.0f)
                close()
                moveTo(13.0f, 19.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-6.97f)
                lineToRelative(5.0f, -3.57f)
                lineToRelative(5.0f, 3.57f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 3.0f)
                lineToRelative(0.0f, 1.97f)
                lineToRelative(2.0f, 1.43f)
                lineToRelative(0.0f, -1.4f)
                lineToRelative(9.0f, 0.0f)
                lineToRelative(0.0f, 14.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, -18.0f)
                close()
            }
        }
        return _homeWork!!
    }

private var _homeWork: ImageVector? = null
