/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NestCamWiredStand: ImageVector
    get() {
        if (_nestCamWiredStand != null) {
            return _nestCamWiredStand!!
        }
        _nestCamWiredStand = materialIcon(name = "Outlined.NestCamWiredStand") {
            materialPath {
                moveTo(16.0f, 1.0f)
                curveToRelative(-0.15f, 0.0f, 0.11f, -0.02f, -4.28f, 0.42f)
                curveTo(8.47f, 1.75f, 6.0f, 4.48f, 6.0f, 7.75f)
                reflectiveCurveToRelative(2.47f, 6.0f, 5.72f, 6.33f)
                lineToRelative(1.9f, 0.19f)
                lineToRelative(-0.56f, 0.85f)
                curveTo(12.71f, 15.04f, 12.36f, 15.0f, 12.0f, 15.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.67f, -0.83f, -3.15f, -2.09f, -4.06f)
                lineToRelative(0.97f, -1.45f)
                curveToRelative(0.04f, 0.0f, 0.09f, 0.01f, 0.13f, 0.01f)
                curveToRelative(1.09f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(18.0f, 1.89f, 17.09f, 1.0f, 16.0f, 1.0f)
                close()
                moveTo(15.0f, 21.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -1.65f, 1.35f, -3.0f, 3.0f, -3.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, 1.35f, 3.0f, 3.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(8.0f, 7.75f)
                curveToRelative(0.0f, -2.25f, 1.69f, -4.11f, 3.92f, -4.34f)
                lineTo(16.0f, 3.0f)
                horizontalLineToRelative(0.0f)
                lineToRelative(0.03f, 9.5f)
                lineToRelative(-4.11f, -0.42f)
                curveTo(9.69f, 11.86f, 8.0f, 10.0f, 8.0f, 7.75f)
                close()
            }
        }
        return _nestCamWiredStand!!
    }

private var _nestCamWiredStand: ImageVector? = null
