/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Pages: ImageVector
    get() {
        if (_pages != null) {
            return _pages!!
        }
        _pages = materialIcon(name = "Outlined.Pages") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(13.0f, 5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(1.0f, -4.0f)
                lineToRelative(-4.0f, 1.0f)
                lineTo(13.0f, 5.0f)
                close()
                moveTo(5.0f, 5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(3.0f)
                lineTo(7.0f, 7.0f)
                lineToRelative(1.0f, 4.0f)
                lineTo(5.0f, 11.0f)
                lineTo(5.0f, 5.0f)
                close()
                moveTo(11.0f, 19.0f)
                lineTo(5.0f, 19.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(-1.0f, 4.0f)
                lineToRelative(4.0f, -1.0f)
                verticalLineToRelative(3.0f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(4.0f, 1.0f)
                lineToRelative(-1.0f, -4.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(14.63f, 14.63f)
                lineTo(12.0f, 13.72f)
                lineToRelative(-2.63f, 0.91f)
                lineToRelative(0.91f, -2.63f)
                lineToRelative(-0.91f, -2.63f)
                lineToRelative(2.63f, 0.91f)
                lineToRelative(2.63f, -0.91f)
                lineToRelative(-0.91f, 2.63f)
                lineToRelative(0.91f, 2.63f)
                close()
            }
        }
        return _pages!!
    }

private var _pages: ImageVector? = null
