/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Token: ImageVector
    get() {
        if (_token != null) {
            return _token!!
        }
        _token = materialIcon(name = "Outlined.Token") {
            materialPath {
                moveTo(21.0f, 7.0f)
                lineToRelative(-9.0f, -5.0f)
                lineTo(3.0f, 7.0f)
                verticalLineToRelative(10.0f)
                lineToRelative(9.0f, 5.0f)
                lineToRelative(9.0f, -5.0f)
                lineTo(21.0f, 7.0f)
                close()
                moveTo(12.0f, 4.29f)
                lineToRelative(5.91f, 3.28f)
                lineTo(14.9f, 9.24f)
                curveTo(14.17f, 8.48f, 13.14f, 8.0f, 12.0f, 8.0f)
                reflectiveCurveTo(9.83f, 8.48f, 9.1f, 9.24f)
                lineTo(6.09f, 7.57f)
                lineTo(12.0f, 4.29f)
                close()
                moveTo(11.0f, 19.16f)
                lineToRelative(-6.0f, -3.33f)
                verticalLineTo(9.26f)
                lineToRelative(3.13f, 1.74f)
                curveTo(8.04f, 11.31f, 8.0f, 11.65f, 8.0f, 12.0f)
                curveToRelative(0.0f, 1.86f, 1.27f, 3.43f, 3.0f, 3.87f)
                verticalLineTo(19.16f)
                close()
                moveTo(10.0f, 12.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(10.0f, 13.1f, 10.0f, 12.0f)
                close()
                moveTo(13.0f, 19.16f)
                verticalLineToRelative(-3.28f)
                curveToRelative(1.73f, -0.44f, 3.0f, -2.01f, 3.0f, -3.87f)
                curveToRelative(0.0f, -0.35f, -0.04f, -0.69f, -0.13f, -1.01f)
                lineTo(19.0f, 9.26f)
                lineToRelative(0.0f, 6.57f)
                lineTo(13.0f, 19.16f)
                close()
            }
        }
        return _token!!
    }

private var _token: ImageVector? = null
