/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BedroomBaby: ImageVector
    get() {
        if (_bedroomBaby != null) {
            return _bedroomBaby!!
        }
        _bedroomBaby = materialIcon(name = "Rounded.BedroomBaby") {
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(12.0f, 17.99f)
                curveToRelative(-2.37f, 0.0f, -4.61f, -0.83f, -6.4f, -2.35f)
                curveToRelative(-0.33f, -0.28f, -0.35f, -0.8f, -0.04f, -1.11f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.27f, -0.27f, 0.71f, -0.29f, 1.01f, -0.04f)
                curveToRelative(0.19f, 0.16f, 0.39f, 0.31f, 0.6f, 0.46f)
                lineTo(8.0f, 13.49f)
                verticalLineTo(9.5f)
                lineToRelative(-1.0f, 0.65f)
                curveToRelative(-0.32f, 0.21f, -0.73f, 0.16f, -0.99f, -0.12f)
                lineTo(6.0f, 10.01f)
                curveToRelative(-0.29f, -0.3f, -0.3f, -0.77f, -0.03f, -1.08f)
                curveTo(6.27f, 8.6f, 6.62f, 8.19f, 6.83f, 7.95f)
                curveTo(6.92f, 7.84f, 6.9f, 7.67f, 6.79f, 7.59f)
                curveToRelative(0.0f, 0.0f, -0.81f, -0.31f, -0.79f, -0.57f)
                curveTo(6.0f, 6.91f, 9.36f, 6.99f, 9.36f, 6.99f)
                curveToRelative(0.18f, 0.0f, 0.34f, 0.1f, 0.43f, 0.25f)
                lineToRelative(1.44f, 2.5f)
                curveToRelative(0.09f, 0.15f, 0.25f, 0.25f, 0.43f, 0.25f)
                horizontalLineToRelative(4.83f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.28f, -0.22f, 0.5f, -0.5f, 0.5f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(2.5f)
                lineToRelative(0.84f, 1.46f)
                curveToRelative(0.2f, -0.15f, 0.4f, -0.3f, 0.6f, -0.46f)
                curveToRelative(0.3f, -0.25f, 0.73f, -0.23f, 1.01f, 0.04f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.31f, 0.31f, 0.29f, 0.82f, -0.04f, 1.11f)
                curveTo(16.61f, 17.16f, 14.37f, 17.99f, 12.0f, 17.99f)
                close()
            }
            materialPath {
                moveTo(14.69f, 14.24f)
                curveToRelative(-1.74f, 0.65f, -3.66f, 0.65f, -5.4f, 0.0f)
                lineToRelative(-0.81f, 1.41f)
                lineToRelative(-0.03f, 0.06f)
                curveToRelative(1.1f, 0.52f, 2.28f, 0.79f, 3.53f, 0.79f)
                reflectiveCurveToRelative(2.45f, -0.28f, 3.55f, -0.79f)
                lineToRelative(-0.03f, -0.06f)
                lineTo(14.69f, 14.24f)
                close()
            }
        }
        return _bedroomBaby!!
    }

private var _bedroomBaby: ImageVector? = null
