/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CurrencyExchange: ImageVector
    get() {
        if (_currencyExchange != null) {
            return _currencyExchange!!
        }
        _currencyExchange = materialIcon(name = "Rounded.CurrencyExchange") {
            materialPath {
                moveTo(12.0f, 23.0f)
                curveToRelative(5.7f, 0.0f, 10.39f, -4.34f, 10.95f, -9.9f)
                curveToRelative(0.06f, -0.59f, -0.41f, -1.1f, -1.0f, -1.1f)
                curveToRelative(-0.51f, 0.0f, -0.94f, 0.38f, -0.99f, 0.88f)
                curveTo(20.52f, 17.44f, 16.67f, 21.0f, 12.0f, 21.0f)
                curveToRelative(-3.12f, 0.0f, -5.87f, -1.59f, -7.48f, -4.0f)
                lineTo(6.0f, 17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                lineToRelative(0.0f, -1.67f)
                curveTo(4.99f, 21.15f, 8.28f, 23.0f, 12.0f, 23.0f)
                close()
                moveTo(12.0f, 1.0f)
                curveTo(6.3f, 1.0f, 1.61f, 5.34f, 1.05f, 10.9f)
                curveTo(1.0f, 11.49f, 1.46f, 12.0f, 2.05f, 12.0f)
                curveToRelative(0.51f, 0.0f, 0.94f, -0.38f, 0.99f, -0.88f)
                curveTo(3.48f, 6.56f, 7.33f, 3.0f, 12.0f, 3.0f)
                curveToRelative(3.12f, 0.0f, 5.87f, 1.59f, 7.48f, 4.0f)
                lineTo(18.0f, 7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                lineToRelative(0.0f, 1.67f)
                curveTo(19.01f, 2.85f, 15.72f, 1.0f, 12.0f, 1.0f)
                close()
                moveTo(11.12f, 5.88f)
                curveTo(11.12f, 5.39f, 11.52f, 5.0f, 12.0f, 5.0f)
                reflectiveCurveToRelative(0.88f, 0.39f, 0.88f, 0.88f)
                lineToRelative(0.0f, 0.37f)
                curveToRelative(1.07f, 0.19f, 1.75f, 0.76f, 2.16f, 1.3f)
                curveToRelative(0.34f, 0.44f, 0.16f, 1.08f, -0.36f, 1.3f)
                curveTo(14.32f, 9.0f, 13.9f, 8.88f, 13.66f, 8.57f)
                curveToRelative(-0.28f, -0.38f, -0.78f, -0.77f, -1.6f, -0.77f)
                curveToRelative(-0.7f, 0.0f, -1.81f, 0.37f, -1.81f, 1.39f)
                curveToRelative(0.0f, 0.95f, 0.86f, 1.31f, 2.64f, 1.9f)
                curveToRelative(2.4f, 0.83f, 3.01f, 2.05f, 3.01f, 3.45f)
                curveToRelative(0.0f, 2.62f, -2.5f, 3.13f, -3.02f, 3.22f)
                lineToRelative(0.0f, 0.37f)
                curveToRelative(0.0f, 0.48f, -0.39f, 0.88f, -0.88f, 0.88f)
                reflectiveCurveToRelative(-0.88f, -0.39f, -0.88f, -0.88f)
                lineToRelative(0.0f, -0.42f)
                curveToRelative(-0.63f, -0.15f, -1.93f, -0.61f, -2.69f, -2.1f)
                curveToRelative(-0.23f, -0.44f, 0.03f, -1.02f, 0.49f, -1.2f)
                curveToRelative(0.41f, -0.16f, 0.9f, -0.01f, 1.11f, 0.38f)
                curveToRelative(0.32f, 0.61f, 0.95f, 1.37f, 2.12f, 1.37f)
                curveToRelative(0.93f, 0.0f, 1.98f, -0.48f, 1.98f, -1.61f)
                curveToRelative(0.0f, -0.96f, -0.7f, -1.46f, -2.28f, -2.03f)
                curveToRelative(-1.1f, -0.39f, -3.35f, -1.03f, -3.35f, -3.31f)
                curveToRelative(0.0f, -0.1f, 0.01f, -2.4f, 2.62f, -2.96f)
                lineTo(11.12f, 5.88f)
                close()
            }
        }
        return _currencyExchange!!
    }

private var _currencyExchange: ImageVector? = null
