/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DoubleArrow: ImageVector
    get() {
        if (_doubleArrow != null) {
            return _doubleArrow!!
        }
        _doubleArrow = materialIcon(name = "Rounded.DoubleArrow") {
            materialPath {
                moveTo(20.08f, 11.42f)
                lineToRelative(-4.04f, -5.65f)
                curveTo(15.7f, 5.29f, 15.15f, 5.0f, 14.56f, 5.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-1.49f, 0.0f, -2.35f, 1.68f, -1.49f, 2.89f)
                lineTo(16.0f, 12.0f)
                lineToRelative(-2.93f, 4.11f)
                curveToRelative(-0.87f, 1.21f, 0.0f, 2.89f, 1.49f, 2.89f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.59f, 0.0f, 1.15f, -0.29f, 1.49f, -0.77f)
                lineToRelative(4.04f, -5.65f)
                curveTo(20.33f, 12.23f, 20.33f, 11.77f, 20.08f, 11.42f)
                close()
            }
            materialPath {
                moveTo(13.08f, 11.42f)
                lineTo(9.05f, 5.77f)
                curveTo(8.7f, 5.29f, 8.15f, 5.0f, 7.56f, 5.0f)
                horizontalLineToRelative(0.0f)
                curveTo(6.07f, 5.0f, 5.2f, 6.68f, 6.07f, 7.89f)
                lineTo(9.0f, 12.0f)
                lineToRelative(-2.93f, 4.11f)
                curveTo(5.2f, 17.32f, 6.07f, 19.0f, 7.56f, 19.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.59f, 0.0f, 1.15f, -0.29f, 1.49f, -0.77f)
                lineToRelative(4.04f, -5.65f)
                curveTo(13.33f, 12.23f, 13.33f, 11.77f, 13.08f, 11.42f)
                close()
            }
        }
        return _doubleArrow!!
    }

private var _doubleArrow: ImageVector? = null
