/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Fastfood: ImageVector
    get() {
        if (_fastfood != null) {
            return _fastfood!!
        }
        _fastfood = materialIcon(name = "Rounded.Fastfood") {
            materialPath {
                moveTo(21.9f, 5.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-3.9f)
                curveToRelative(-0.59f, 0.0f, -1.05f, 0.51f, -1.0f, 1.1f)
                lineToRelative(0.12f, 1.21f)
                curveTo(14.9f, 8.16f, 18.0f, 10.77f, 18.0f, 15.0f)
                lineToRelative(0.02f, 8.0f)
                horizontalLineToRelative(1.7f)
                curveToRelative(0.84f, 0.0f, 1.53f, -0.65f, 1.63f, -1.47f)
                lineTo(22.89f, 6.1f)
                curveToRelative(0.06f, -0.59f, -0.4f, -1.1f, -0.99f, -1.1f)
                close()
                moveTo(15.0f, 21.0f)
                horizontalLineTo(2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                close()
                moveTo(2.1f, 15.0f)
                horizontalLineToRelative(12.8f)
                curveToRelative(0.62f, 0.0f, 1.11f, -0.56f, 0.99f, -1.16f)
                curveToRelative(-0.65f, -3.23f, -4.02f, -4.85f, -7.39f, -4.85f)
                reflectiveCurveToRelative(-6.73f, 1.62f, -7.39f, 4.85f)
                curveToRelative(-0.12f, 0.6f, 0.38f, 1.16f, 0.99f, 1.16f)
                close()
                moveTo(15.0f, 17.0f)
                horizontalLineTo(2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                close()
            }
        }
        return _fastfood!!
    }

private var _fastfood: ImageVector? = null
