/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Fluorescent: ImageVector
    get() {
        if (_fluorescent != null) {
            return _fluorescent!!
        }
        _fluorescent = materialIcon(name = "Rounded.Fluorescent") {
            materialPath {
                moveTo(7.0f, 15.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(2.0f)
                curveTo(5.0f, 14.1f, 5.9f, 15.0f, 7.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                lineTo(12.0f, 2.0f)
                curveToRelative(-0.56f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(12.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(3.0f)
                curveTo(13.0f, 2.45f, 12.55f, 2.0f, 12.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(19.79f, 5.3f)
                lineTo(19.79f, 5.3f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-0.38f, 0.38f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.38f, -0.38f)
                curveTo(20.18f, 6.33f, 20.18f, 5.69f, 19.79f, 5.3f)
                close()
            }
            materialPath {
                moveTo(12.0f, 22.0f)
                lineTo(12.0f, 22.0f)
                curveToRelative(0.56f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(12.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(21.0f)
                curveTo(11.0f, 21.55f, 11.45f, 22.0f, 12.0f, 22.0f)
                close()
            }
            materialPath {
                moveTo(17.99f, 18.41f)
                lineToRelative(0.38f, 0.39f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.01f, -0.01f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(19.4f, 17.0f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(17.6f, 17.4f, 17.6f, 18.03f, 17.99f, 18.41f)
                close()
            }
            materialPath {
                moveTo(6.0f, 5.69f)
                lineTo(5.61f, 5.31f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(4.59f, 7.1f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(6.38f, 6.71f, 6.38f, 6.07f, 6.0f, 5.69f)
                close()
            }
            materialPath {
                moveTo(4.2f, 18.79f)
                lineTo(4.2f, 18.79f)
                curveToRelative(0.39f, 0.4f, 1.03f, 0.4f, 1.42f, 0.0f)
                lineTo(6.0f, 18.4f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(4.2f, 17.38f)
                curveTo(3.81f, 17.77f, 3.81f, 18.4f, 4.2f, 18.79f)
                close()
            }
        }
        return _fluorescent!!
    }

private var _fluorescent: ImageVector? = null
