/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalSee: ImageVector
    get() {
        if (_localSee != null) {
            return _localSee!!
        }
        _localSee = materialIcon(name = "Rounded.LocalSee") {
            materialPath {
                moveTo(9.5f, 14.0f)
                curveToRelative(0.0f, 1.38f, 1.12f, 2.5f, 2.5f, 2.5f)
                curveToRelative(1.23f, 0.0f, 2.25f, -0.9f, 2.46f, -2.07f)
                curveToRelative(-1.0f, -1.01f, -1.83f, -1.98f, -2.48f, -2.93f)
                curveTo(10.61f, 11.52f, 9.5f, 12.63f, 9.5f, 14.0f)
                close()
            }
            materialPath {
                moveTo(18.65f, 17.08f)
                curveToRelative(-0.37f, 0.32f, -0.92f, 0.32f, -1.3f, 0.0f)
                curveToRelative(-1.26f, -1.08f, -0.7f, -0.61f, -1.3f, -1.14f)
                curveToRelative(-0.83f, 1.74f, -2.73f, 2.87f, -4.85f, 2.5f)
                curveToRelative(-1.83f, -0.32f, -3.31f, -1.8f, -3.63f, -3.63f)
                curveToRelative(-0.42f, -2.44f, 1.13f, -4.58f, 3.31f, -5.14f)
                curveTo(10.3f, 8.45f, 10.0f, 7.28f, 10.0f, 6.15f)
                curveTo(10.0f, 5.4f, 10.1f, 4.68f, 10.28f, 4.0f)
                horizontalLineToRelative(-0.4f)
                curveToRelative(-0.56f, 0.0f, -1.1f, 0.24f, -1.48f, 0.65f)
                lineTo(7.17f, 6.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 6.0f, 2.0f, 6.9f, 2.0f, 8.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-6.03f)
                curveTo(20.59f, 15.46f, 19.35f, 16.48f, 18.65f, 17.08f)
                close()
            }
            materialPath {
                moveTo(17.34f, 14.42f)
                curveToRelative(0.37f, 0.33f, 0.95f, 0.33f, 1.33f, 0.0f)
                curveTo(22.22f, 11.25f, 24.0f, 8.5f, 24.0f, 6.15f)
                curveTo(24.0f, 2.42f, 21.15f, 0.0f, 18.0f, 0.0f)
                reflectiveCurveToRelative(-6.0f, 2.42f, -6.0f, 6.15f)
                curveTo(12.0f, 8.5f, 13.78f, 11.25f, 17.34f, 14.42f)
                close()
                moveTo(17.27f, 5.25f)
                lineTo(18.0f, 3.0f)
                lineToRelative(0.73f, 2.25f)
                horizontalLineTo(21.0f)
                lineToRelative(-1.85f, 1.47f)
                lineTo(19.85f, 9.0f)
                lineTo(18.0f, 7.59f)
                lineTo(16.15f, 9.0f)
                lineToRelative(0.7f, -2.28f)
                lineTo(15.0f, 5.25f)
                horizontalLineTo(17.27f)
                close()
            }
        }
        return _localSee!!
    }

private var _localSee: ImageVector? = null
