/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NotificationsPaused: ImageVector
    get() {
        if (_notificationsPaused != null) {
            return _notificationsPaused!!
        }
        _notificationsPaused = materialIcon(name = "Rounded.NotificationsPaused") {
            materialPath {
                moveTo(12.0f, 22.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                close()
                moveTo(19.29f, 17.29f)
                lineTo(18.0f, 16.0f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -3.07f, -1.64f, -5.64f, -4.5f, -6.32f)
                lineTo(13.5f, 4.0f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveToRelative(-1.5f, 0.67f, -1.5f, 1.5f)
                verticalLineToRelative(0.68f)
                curveTo(7.63f, 5.36f, 6.0f, 7.92f, 6.0f, 11.0f)
                verticalLineToRelative(5.0f)
                lineToRelative(-1.29f, 1.29f)
                curveToRelative(-0.63f, 0.63f, -0.19f, 1.71f, 0.7f, 1.71f)
                horizontalLineToRelative(13.17f)
                curveToRelative(0.9f, 0.0f, 1.34f, -1.08f, 0.71f, -1.71f)
                close()
                moveTo(14.5f, 9.33f)
                curveToRelative(0.0f, 0.31f, -0.11f, 0.6f, -0.3f, 0.84f)
                lineToRelative(-2.5f, 3.03f)
                horizontalLineToRelative(1.9f)
                curveToRelative(0.5f, 0.0f, 0.9f, 0.4f, 0.9f, 0.9f)
                reflectiveCurveToRelative(-0.4f, 0.9f, -0.9f, 0.9f)
                horizontalLineToRelative(-2.78f)
                curveToRelative(-0.73f, 0.0f, -1.32f, -0.59f, -1.32f, -1.32f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.31f, 0.11f, -0.6f, 0.3f, -0.84f)
                lineToRelative(2.5f, -3.03f)
                horizontalLineToRelative(-1.9f)
                curveToRelative(-0.5f, 0.0f, -0.9f, -0.4f, -0.9f, -0.9f)
                reflectiveCurveToRelative(0.4f, -0.9f, 0.9f, -0.9f)
                horizontalLineToRelative(2.78f)
                curveToRelative(0.73f, 0.0f, 1.32f, 0.59f, 1.32f, 1.33f)
                close()
            }
        }
        return _notificationsPaused!!
    }

private var _notificationsPaused: ImageVector? = null
