/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SolarPower: ImageVector
    get() {
        if (_solarPower != null) {
            return _solarPower!!
        }
        _solarPower = materialIcon(name = "Rounded.SolarPower") {
            materialPath {
                moveTo(3.33f, 16.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(5.6f)
                curveToRelative(-0.94f, 0.0f, -1.75f, 0.65f, -1.95f, 1.57f)
                lineTo(3.33f, 16.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 16.0f)
                horizontalLineToRelative(7.67f)
                lineToRelative(-0.32f, -1.43f)
                curveTo(20.14f, 13.65f, 19.33f, 13.0f, 18.4f, 13.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(21.11f, 18.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(6.51f)
                curveToRelative(1.28f, 0.0f, 2.23f, -1.18f, 1.95f, -2.43f)
                lineTo(21.11f, 18.0f)
                close()
            }
            materialPath {
                moveTo(4.49f, 22.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(2.89f)
                lineToRelative(-0.35f, 1.57f)
                curveTo(2.26f, 20.82f, 3.21f, 22.0f, 4.49f, 22.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 8.0f)
                lineTo(12.0f, 8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(9.0f)
                curveTo(13.0f, 8.45f, 12.55f, 8.0f, 12.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(18.59f, 8.62f)
                lineTo(18.59f, 8.62f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(17.88f, 6.5f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.71f, 0.71f)
                curveTo(17.57f, 9.01f, 18.2f, 9.01f, 18.59f, 8.62f)
                close()
            }
            materialPath {
                moveTo(6.82f, 8.62f)
                lineToRelative(0.71f, -0.71f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(5.41f, 7.2f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.0f, 0.0f)
                curveTo(5.8f, 9.01f, 6.43f, 9.01f, 6.82f, 8.62f)
                close()
            }
            materialPath {
                moveTo(5.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 2.0f, 3.0f, 2.45f, 3.0f, 3.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(6.0f, 2.45f, 5.55f, 2.0f, 5.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(21.0f, 2.45f, 20.55f, 2.0f, 20.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 7.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                horizontalLineTo(7.0f)
                curveTo(7.0f, 4.76f, 9.24f, 7.0f, 12.0f, 7.0f)
                close()
            }
        }
        return _solarPower!!
    }

private var _solarPower: ImageVector? = null
