/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SwitchLeft: ImageVector
    get() {
        if (_switchLeft != null) {
            return _switchLeft!!
        }
        _switchLeft = materialIcon(name = "Rounded.SwitchLeft") {
            materialPath {
                moveTo(8.5f, 8.62f)
                verticalLineToRelative(6.76f)
                lineTo(5.12f, 12.0f)
                lineTo(8.5f, 8.62f)
                moveTo(3.71f, 11.29f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(4.59f, 4.59f)
                curveTo(8.92f, 17.92f, 10.0f, 17.48f, 10.0f, 16.59f)
                verticalLineTo(7.41f)
                curveToRelative(0.0f, -0.89f, -1.08f, -1.34f, -1.71f, -0.71f)
                lineTo(3.71f, 11.29f)
                close()
                moveTo(14.0f, 7.41f)
                verticalLineToRelative(9.17f)
                curveToRelative(0.0f, 0.89f, 1.08f, 1.34f, 1.71f, 0.71f)
                lineToRelative(4.59f, -4.59f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-4.59f, -4.59f)
                curveTo(15.08f, 6.08f, 14.0f, 6.52f, 14.0f, 7.41f)
                close()
            }
        }
        return _switchLeft!!
    }

private var _switchLeft: ImageVector? = null
