/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Tour: ImageVector
    get() {
        if (_tour != null) {
            return _tour!!
        }
        _tour = materialIcon(name = "Rounded.Tour") {
            materialPath {
                moveTo(20.45f, 5.37f)
                curveTo(20.71f, 4.71f, 20.23f, 4.0f, 19.52f, 4.0f)
                horizontalLineTo(13.0f)
                horizontalLineToRelative(-1.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveTo(5.45f, 2.0f, 5.0f, 2.45f, 5.0f, 3.0f)
                verticalLineToRelative(1.0f)
                verticalLineToRelative(10.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(4.0f)
                horizontalLineToRelative(1.0f)
                horizontalLineToRelative(7.52f)
                curveToRelative(0.71f, 0.0f, 1.19f, -0.71f, 0.93f, -1.37f)
                lineTo(19.0f, 9.0f)
                lineTo(20.45f, 5.37f)
                close()
                moveTo(15.0f, 9.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(15.0f, 7.9f, 15.0f, 9.0f)
                close()
            }
        }
        return _tour!!
    }

private var _tour: ImageVector? = null
