/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Wifi2Bar: ImageVector
    get() {
        if (_wifi2Bar != null) {
            return _wifi2Bar!!
        }
        _wifi2Bar = materialIcon(name = "Rounded.Wifi2Bar") {
            materialPath {
                moveTo(12.0f, 16.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(13.1f, 16.0f, 12.0f, 16.0f)
                close()
                moveTo(5.38f, 14.37f)
                curveToRelative(-0.63f, -0.63f, -0.59f, -1.71f, 0.13f, -2.24f)
                curveTo(7.33f, 10.79f, 9.57f, 10.0f, 12.0f, 10.0f)
                curveToRelative(2.43f, 0.0f, 4.67f, 0.79f, 6.49f, 2.13f)
                curveToRelative(0.72f, 0.53f, 0.76f, 1.6f, 0.13f, 2.24f)
                curveToRelative(-0.53f, 0.54f, -1.37f, 0.57f, -1.98f, 0.12f)
                curveTo(15.33f, 13.55f, 13.73f, 13.0f, 12.0f, 13.0f)
                curveToRelative(-1.73f, 0.0f, -3.33f, 0.55f, -4.64f, 1.49f)
                curveTo(6.75f, 14.93f, 5.91f, 14.9f, 5.38f, 14.37f)
                close()
            }
        }
        return _wifi2Bar!!
    }

private var _wifi2Bar: ImageVector? = null
