/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AirplaneTicket: ImageVector
    get() {
        if (_airplaneTicket != null) {
            return _airplaneTicket!!
        }
        _airplaneTicket = materialIcon(name = "Sharp.AirplaneTicket") {
            materialPath {
                moveTo(22.0f, 4.0f)
                horizontalLineTo(2.01f)
                verticalLineToRelative(6.0f)
                curveTo(3.11f, 10.0f, 4.0f, 10.9f, 4.0f, 12.0f)
                reflectiveCurveToRelative(-0.89f, 2.0f, -2.0f, 2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(17.73f, 13.3f)
                lineToRelative(-8.86f, 2.36f)
                lineToRelative(-1.66f, -2.88f)
                lineToRelative(0.93f, -0.25f)
                lineToRelative(1.26f, 0.99f)
                lineToRelative(2.39f, -0.64f)
                lineToRelative(-2.4f, -4.16f)
                lineToRelative(1.4f, -0.38f)
                lineToRelative(4.01f, 3.74f)
                lineToRelative(2.44f, -0.65f)
                curveToRelative(0.51f, -0.14f, 1.04f, 0.17f, 1.18f, 0.68f)
                curveTo(18.55f, 12.62f, 18.25f, 13.15f, 17.73f, 13.3f)
                close()
            }
        }
        return _airplaneTicket!!
    }

private var _airplaneTicket: ImageVector? = null
