/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ElectricBike: ImageVector
    get() {
        if (_electricBike != null) {
            return _electricBike!!
        }
        _electricBike = materialIcon(name = "Sharp.ElectricBike") {
            materialPath {
                moveTo(19.0f, 7.0f)
                horizontalLineToRelative(-0.82f)
                lineTo(16.0f, 1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.6f)
                lineToRelative(1.46f, 4.0f)
                horizontalLineToRelative(-4.81f)
                lineToRelative(-0.36f, -1.0f)
                horizontalLineTo(12.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(1.75f)
                lineToRelative(1.82f, 5.0f)
                horizontalLineTo(9.9f)
                curveTo(9.46f, 8.77f, 7.59f, 7.12f, 5.25f, 7.01f)
                curveTo(2.45f, 6.87f, 0.0f, 9.2f, 0.0f, 12.0f)
                curveToRelative(0.0f, 2.8f, 2.2f, 5.0f, 5.0f, 5.0f)
                curveToRelative(2.46f, 0.0f, 4.45f, -1.69f, 4.9f, -4.0f)
                horizontalLineToRelative(4.2f)
                curveToRelative(0.44f, 2.23f, 2.31f, 3.88f, 4.65f, 3.99f)
                curveToRelative(2.8f, 0.13f, 5.25f, -2.19f, 5.25f, -5.0f)
                curveTo(24.0f, 9.2f, 21.8f, 7.0f, 19.0f, 7.0f)
                close()
                moveTo(7.82f, 13.0f)
                curveToRelative(-0.4f, 1.17f, -1.49f, 2.0f, -2.82f, 2.0f)
                curveToRelative(-1.68f, 0.0f, -3.0f, -1.32f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.32f, -3.0f, 3.0f, -3.0f)
                curveToRelative(1.33f, 0.0f, 2.42f, 0.83f, 2.82f, 2.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(7.82f)
                close()
                moveTo(14.1f, 11.0f)
                horizontalLineToRelative(-1.4f)
                lineToRelative(-0.73f, -2.0f)
                horizontalLineTo(15.0f)
                curveTo(14.56f, 9.58f, 14.24f, 10.25f, 14.1f, 11.0f)
                close()
                moveTo(19.0f, 15.0f)
                curveToRelative(-1.68f, 0.0f, -3.0f, -1.32f, -3.0f, -3.0f)
                curveToRelative(0.0f, -0.93f, 0.41f, -1.73f, 1.05f, -2.28f)
                lineToRelative(0.96f, 2.64f)
                lineToRelative(1.88f, -0.68f)
                lineToRelative(-0.97f, -2.67f)
                curveTo(18.94f, 9.01f, 18.97f, 9.0f, 19.0f, 9.0f)
                curveToRelative(1.68f, 0.0f, 3.0f, 1.32f, 3.0f, 3.0f)
                reflectiveCurveTo(20.68f, 15.0f, 19.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 20.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(6.0f, 3.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(-6.0f, -3.0f)
                close()
            }
        }
        return _electricBike!!
    }

private var _electricBike: ImageVector? = null
