/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MiscellaneousServices: ImageVector
    get() {
        if (_miscellaneousServices != null) {
            return _miscellaneousServices!!
        }
        _miscellaneousServices = materialIcon(name = "Sharp.MiscellaneousServices") {
            materialPath {
                moveTo(14.02f, 13.97f)
                lineToRelative(1.7f, -2.94f)
                curveToRelative(0.0f, 0.0f, -0.09f, -0.08f, -0.23f, -0.18f)
                lineToRelative(-1.47f, -1.16f)
                lineToRelative(-0.01f, 0.02f)
                curveToRelative(0.03f, -0.24f, 0.05f, -0.47f, 0.05f, -0.71f)
                reflectiveCurveTo(14.04f, 8.53f, 14.0f, 8.31f)
                lineToRelative(0.01f, 0.01f)
                lineToRelative(1.71f, -1.34f)
                lineToRelative(-1.7f, -2.95f)
                lineToRelative(-2.01f, 0.81f)
                verticalLineToRelative(0.01f)
                curveToRelative(-0.37f, -0.28f, -0.77f, -0.52f, -1.2f, -0.7f)
                horizontalLineToRelative(0.01f)
                lineTo(10.52f, 2.0f)
                horizontalLineTo(7.11f)
                lineTo(6.8f, 4.15f)
                horizontalLineToRelative(0.01f)
                curveToRelative(-0.43f, 0.18f, -0.83f, 0.42f, -1.2f, 0.7f)
                verticalLineTo(4.84f)
                lineTo(3.6f, 4.03f)
                lineTo(1.9f, 6.98f)
                lineToRelative(1.7f, 1.34f)
                lineToRelative(0.01f, -0.01f)
                curveTo(3.58f, 8.53f, 3.56f, 8.76f, 3.56f, 9.0f)
                reflectiveCurveToRelative(0.02f, 0.47f, 0.05f, 0.71f)
                lineTo(3.6f, 9.69f)
                lineToRelative(-1.47f, 1.16f)
                curveTo(2.0f, 10.95f, 1.9f, 11.03f, 1.9f, 11.03f)
                lineToRelative(1.7f, 2.94f)
                lineToRelative(2.02f, -0.8f)
                lineTo(5.6f, 13.14f)
                curveToRelative(0.37f, 0.29f, 0.77f, 0.53f, 1.21f, 0.71f)
                horizontalLineTo(6.8f)
                lineTo(7.11f, 16.0f)
                horizontalLineToRelative(3.4f)
                curveToRelative(0.0f, 0.0f, 0.02f, -0.13f, 0.04f, -0.3f)
                lineToRelative(0.27f, -1.85f)
                horizontalLineToRelative(-0.01f)
                curveToRelative(0.44f, -0.18f, 0.84f, -0.42f, 1.21f, -0.71f)
                lineTo(12.0f, 13.17f)
                lineTo(14.02f, 13.97f)
                close()
                moveTo(8.81f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveTo(9.91f, 11.0f, 8.81f, 11.0f)
                close()
            }
            materialPath {
                moveTo(20.98f, 17.94f)
                lineToRelative(-0.01f, 0.01f)
                curveTo(20.99f, 17.8f, 21.0f, 17.65f, 21.0f, 17.5f)
                curveToRelative(0.0f, -0.15f, -0.01f, -0.3f, -0.04f, -0.44f)
                lineToRelative(0.01f, 0.01f)
                lineToRelative(1.1f, -0.86f)
                lineToRelative(-1.09f, -1.9f)
                lineToRelative(-1.29f, 0.52f)
                verticalLineToRelative(0.01f)
                curveToRelative(-0.24f, -0.18f, -0.49f, -0.33f, -0.77f, -0.45f)
                horizontalLineToRelative(0.01f)
                lineTo(18.73f, 13.0f)
                horizontalLineToRelative(-2.19f)
                lineToRelative(-0.2f, 1.38f)
                horizontalLineToRelative(0.01f)
                curveToRelative(-0.28f, 0.12f, -0.53f, 0.27f, -0.77f, 0.45f)
                verticalLineToRelative(-0.01f)
                lineToRelative(-1.29f, -0.52f)
                lineToRelative(-1.09f, 1.9f)
                lineToRelative(1.09f, 0.86f)
                lineToRelative(0.01f, -0.01f)
                curveToRelative(-0.02f, 0.14f, -0.03f, 0.29f, -0.03f, 0.44f)
                curveToRelative(0.0f, 0.15f, 0.01f, 0.3f, 0.03f, 0.46f)
                lineToRelative(-0.01f, -0.01f)
                lineToRelative(-0.94f, 0.75f)
                curveToRelative(-0.08f, 0.06f, -0.15f, 0.12f, -0.15f, 0.12f)
                lineToRelative(1.09f, 1.89f)
                lineToRelative(1.3f, -0.51f)
                lineToRelative(-0.01f, -0.02f)
                curveToRelative(0.24f, 0.19f, 0.5f, 0.34f, 0.78f, 0.46f)
                horizontalLineToRelative(-0.01f)
                lineToRelative(0.2f, 1.38f)
                horizontalLineToRelative(2.19f)
                curveToRelative(0.0f, 0.0f, 0.01f, -0.08f, 0.03f, -0.19f)
                lineToRelative(0.17f, -1.19f)
                horizontalLineToRelative(-0.01f)
                curveToRelative(0.28f, -0.12f, 0.54f, -0.27f, 0.78f, -0.46f)
                lineToRelative(-0.01f, 0.02f)
                lineToRelative(1.3f, 0.51f)
                lineToRelative(1.09f, -1.89f)
                curveToRelative(0.0f, 0.0f, -0.06f, -0.05f, -0.15f, -0.12f)
                lineTo(20.98f, 17.94f)
                close()
                moveTo(17.63f, 18.79f)
                curveToRelative(-0.71f, 0.0f, -1.29f, -0.58f, -1.29f, -1.29f)
                reflectiveCurveToRelative(0.58f, -1.29f, 1.29f, -1.29f)
                reflectiveCurveToRelative(1.29f, 0.58f, 1.29f, 1.29f)
                reflectiveCurveTo(18.34f, 18.79f, 17.63f, 18.79f)
                close()
            }
        }
        return _miscellaneousServices!!
    }

private var _miscellaneousServices: ImageVector? = null
