/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SpaceDashboard: ImageVector
    get() {
        if (_spaceDashboard != null) {
            return _spaceDashboard!!
        }
        _spaceDashboard = materialIcon(name = "Sharp.SpaceDashboard") {
            materialPath {
                moveTo(11.0f, 21.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(13.0f, 21.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-9.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(21.0f, 10.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(21.0f)
                close()
            }
        }
        return _spaceDashboard!!
    }

private var _spaceDashboard: ImageVector? = null
