/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Subscript: ImageVector
    get() {
        if (_subscript != null) {
            return _subscript!!
        }
        _subscript = materialIcon(name = "Sharp.Subscript") {
            materialPath {
                moveTo(20.0f, 18.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(5.88f, 18.0f)
                horizontalLineToRelative(2.66f)
                lineToRelative(3.4f, -5.42f)
                horizontalLineToRelative(0.12f)
                lineToRelative(3.4f, 5.42f)
                horizontalLineToRelative(2.66f)
                lineToRelative(-4.65f, -7.27f)
                lineTo(17.81f, 4.0f)
                horizontalLineToRelative(-2.68f)
                lineToRelative(-3.07f, 4.99f)
                horizontalLineToRelative(-0.12f)
                lineTo(8.85f, 4.0f)
                horizontalLineTo(6.19f)
                lineToRelative(4.32f, 6.73f)
                lineTo(5.88f, 18.0f)
                close()
            }
        }
        return _subscript!!
    }

private var _subscript: ImageVector? = null
