/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TurnSlightRight: ImageVector
    get() {
        if (_turnSlightRight != null) {
            return _turnSlightRight!!
        }
        _turnSlightRight = materialIcon(name = "Sharp.TurnSlightRight") {
            materialPath {
                moveTo(12.34f, 6.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(5.66f, 0.0f)
                lineToRelative(0.0f, 5.66f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -2.25f)
                lineToRelative(-5.0f, 5.0f)
                lineToRelative(0.0f, 7.59f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -8.41f)
                lineToRelative(5.59f, -5.59f)
                close()
            }
        }
        return _turnSlightRight!!
    }

private var _turnSlightRight: ImageVector? = null
