/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ViewDay: ImageVector
    get() {
        if (_viewDay != null) {
            return _viewDay!!
        }
        _viewDay = materialIcon(name = "Sharp.ViewDay") {
            materialPath {
                moveTo(2.0f, 21.0f)
                horizontalLineToRelative(19.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(3.0f)
                close()
                moveTo(21.0f, 8.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(19.0f)
                verticalLineTo(8.0f)
                close()
                moveTo(2.0f, 3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(19.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(2.0f)
                close()
            }
        }
        return _viewDay!!
    }

private var _viewDay: ImageVector? = null
