/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Vrpano: ImageVector
    get() {
        if (_vrpano != null) {
            return _vrpano!!
        }
        _vrpano = materialIcon(name = "Sharp.Vrpano") {
            materialPath {
                moveTo(12.0f, 5.5f)
                curveToRelative(-5.25f, 0.0f, -9.01f, -1.54f, -10.0f, -1.92f)
                verticalLineTo(20.4f)
                curveToRelative(2.16f, -0.76f, 5.21f, -1.9f, 10.0f, -1.9f)
                curveToRelative(4.78f, 0.0f, 7.91f, 1.17f, 10.0f, 1.9f)
                verticalLineTo(3.6f)
                curveTo(19.91f, 4.33f, 16.77f, 5.5f, 12.0f, 5.5f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-2.34f, 0.0f, -4.52f, 0.15f, -6.52f, 0.41f)
                lineToRelative(3.69f, -4.42f)
                lineToRelative(2.0f, 2.4f)
                lineTo(14.0f, 10.0f)
                lineToRelative(4.51f, 5.4f)
                curveTo(16.52f, 15.15f, 14.3f, 15.0f, 12.0f, 15.0f)
                close()
            }
        }
        return _vrpano!!
    }

private var _vrpano: ImageVector? = null
