/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AllInbox: ImageVector
    get() {
        if (_allInbox != null) {
            return _allInbox!!
        }
        _allInbox = materialIcon(name = "TwoTone.AllInbox") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(7.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(5.0f, 10.0f)
                horizontalLineToRelative(3.13f)
                curveToRelative(0.21f, 0.78f, 0.67f, 1.47f, 1.27f, 2.0f)
                lineTo(5.0f, 12.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(19.0f, 12.0f)
                horizontalLineToRelative(-4.4f)
                curveToRelative(0.6f, -0.53f, 1.06f, -1.22f, 1.27f, -2.0f)
                lineTo(19.0f, 10.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(19.0f, 8.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.07f, -0.93f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.93f, -2.0f, -2.0f)
                lineTo(10.0f, 8.0f)
                lineTo(5.0f, 8.0f)
                lineTo(5.0f, 5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(3.0f)
                close()
                moveTo(14.0f, 15.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.47f, -0.19f, 0.9f, -0.48f, 1.25f)
                curveToRelative(-0.37f, 0.45f, -0.92f, 0.75f, -1.52f, 0.75f)
                reflectiveCurveToRelative(-1.15f, -0.3f, -1.52f, -0.75f)
                curveToRelative(-0.29f, -0.35f, -0.48f, -0.78f, -0.48f, -1.25f)
                verticalLineToRelative(-1.0f)
                lineTo(3.0f, 15.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-7.0f)
                close()
                moveTo(5.0f, 17.0f)
                horizontalLineToRelative(3.13f)
                curveToRelative(0.02f, 0.09f, 0.06f, 0.17f, 0.09f, 0.25f)
                curveToRelative(0.24f, 0.68f, 0.65f, 1.28f, 1.18f, 1.75f)
                lineTo(5.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineToRelative(-4.4f)
                curveToRelative(0.54f, -0.47f, 0.95f, -1.07f, 1.18f, -1.75f)
                curveToRelative(0.03f, -0.08f, 0.07f, -0.16f, 0.09f, -0.25f)
                lineTo(19.0f, 17.0f)
                verticalLineToRelative(2.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.13f, 10.0f)
                lineTo(5.0f, 10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.4f)
                curveToRelative(-0.6f, -0.53f, -1.06f, -1.22f, -1.27f, -2.0f)
                close()
                moveTo(14.6f, 12.0f)
                lineTo(19.0f, 12.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.13f)
                curveToRelative(-0.21f, 0.78f, -0.67f, 1.47f, -1.27f, 2.0f)
                close()
                moveTo(8.22f, 17.25f)
                curveToRelative(-0.03f, -0.08f, -0.06f, -0.16f, -0.09f, -0.25f)
                lineTo(5.0f, 17.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.4f)
                curveToRelative(-0.53f, -0.47f, -0.94f, -1.07f, -1.18f, -1.75f)
                close()
                moveTo(15.87f, 17.0f)
                curveToRelative(-0.02f, 0.09f, -0.06f, 0.17f, -0.09f, 0.25f)
                curveToRelative(-0.23f, 0.68f, -0.64f, 1.28f, -1.18f, 1.75f)
                lineTo(19.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.13f)
                close()
            }
        }
        return _allInbox!!
    }

private var _allInbox: ImageVector? = null
