/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CancelScheduleSend: ImageVector
    get() {
        if (_cancelScheduleSend != null) {
            return _cancelScheduleSend!!
        }
        _cancelScheduleSend = materialIcon(name = "TwoTone.CancelScheduleSend") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 17.97f)
                lineToRelative(6.1f, -2.61f)
                curveToRelative(0.02f, -0.14f, 0.04f, -0.29f, 0.07f, -0.43f)
                lineTo(3.0f, 15.75f)
                verticalLineTo(17.97f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.5f, 11.0f)
                curveToRelative(-3.03f, 0.0f, -5.5f, 2.47f, -5.5f, 5.5f)
                reflectiveCurveToRelative(2.47f, 5.5f, 5.5f, 5.5f)
                reflectiveCurveToRelative(5.5f, -2.47f, 5.5f, -5.5f)
                reflectiveCurveTo(19.53f, 11.0f, 16.5f, 11.0f)
                close()
                moveTo(18.97f, 18.27f)
                lineToRelative(-0.71f, 0.71f)
                lineToRelative(-1.77f, -1.77f)
                lineToRelative(-1.77f, 1.77f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(1.77f, -1.77f)
                lineToRelative(-1.77f, -1.77f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(1.77f, 1.77f)
                lineToRelative(1.77f, -1.77f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(-1.77f, 1.77f)
                lineTo(18.97f, 18.27f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 8.25f)
                lineToRelative(7.52f, 1.0f)
                lineToRelative(-7.51f, -3.22f)
                close()
            }
            materialPath {
                moveTo(16.5f, 9.0f)
                curveToRelative(-0.42f, 0.0f, -0.83f, 0.04f, -1.24f, 0.11f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                lineTo(1.01f, 3.0f)
                lineTo(1.0f, 10.0f)
                lineToRelative(10.06f, 1.34f)
                curveToRelative(-0.42f, 0.44f, -0.78f, 0.93f, -1.09f, 1.46f)
                lineTo(1.0f, 14.0f)
                lineToRelative(0.01f, 7.0f)
                lineToRelative(8.07f, -3.46f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveTo(9.59f, 21.19f, 12.71f, 24.0f, 16.5f, 24.0f)
                curveToRelative(4.14f, 0.0f, 7.5f, -3.36f, 7.5f, -7.5f)
                reflectiveCurveTo(20.64f, 9.0f, 16.5f, 9.0f)
                close()
                moveTo(3.0f, 8.25f)
                lineToRelative(0.01f, -2.22f)
                lineToRelative(7.51f, 3.22f)
                lineTo(3.0f, 8.25f)
                close()
                moveTo(9.1f, 15.36f)
                lineTo(3.0f, 17.97f)
                verticalLineToRelative(-2.22f)
                lineToRelative(6.17f, -0.82f)
                curveTo(9.14f, 15.07f, 9.12f, 15.21f, 9.1f, 15.36f)
                close()
                moveTo(16.5f, 22.0f)
                curveToRelative(-3.03f, 0.0f, -5.5f, -2.47f, -5.5f, -5.5f)
                reflectiveCurveToRelative(2.47f, -5.5f, 5.5f, -5.5f)
                reflectiveCurveToRelative(5.5f, 2.47f, 5.5f, 5.5f)
                reflectiveCurveTo(19.53f, 22.0f, 16.5f, 22.0f)
                close()
            }
            materialPath {
                moveTo(18.27f, 14.03f)
                lineToRelative(-1.77f, 1.76f)
                lineToRelative(-1.77f, -1.76f)
                lineToRelative(-0.7f, 0.7f)
                lineToRelative(1.76f, 1.77f)
                lineToRelative(-1.76f, 1.77f)
                lineToRelative(0.7f, 0.7f)
                lineToRelative(1.77f, -1.76f)
                lineToRelative(1.77f, 1.76f)
                lineToRelative(0.7f, -0.7f)
                lineToRelative(-1.76f, -1.77f)
                lineToRelative(1.76f, -1.77f)
                close()
            }
        }
        return _cancelScheduleSend!!
    }

private var _cancelScheduleSend: ImageVector? = null
