/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MarkAsUnread: ImageVector
    get() {
        if (_markAsUnread != null) {
            return _markAsUnread!!
        }
        _markAsUnread = materialIcon(name = "TwoTone.MarkAsUnread") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.5f, 13.33f)
                lineToRelative(6.5f, -3.33f)
                lineToRelative(-13.0f, 0.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.0f, 12.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(13.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-6.5f, 3.33f)
                close()
            }
            materialPath {
                moveTo(16.23f, 7.0f)
                horizontalLineToRelative(2.6f)
                curveToRelative(-0.06f, -0.47f, -0.36f, -0.94f, -0.79f, -1.17f)
                lineTo(10.5f, 2.0f)
                lineTo(2.8f, 5.83f)
                curveTo(2.32f, 6.09f, 2.0f, 6.64f, 2.0f, 7.17f)
                verticalLineTo(15.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                verticalLineTo(7.4f)
                lineTo(10.5f, 4.0f)
                lineTo(16.23f, 7.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 8.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-9.0f)
                curveTo(22.0f, 8.9f, 21.1f, 8.0f, 20.0f, 8.0f)
                close()
                moveTo(20.0f, 19.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-7.0f)
                lineToRelative(6.5f, 3.33f)
                lineTo(20.0f, 12.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(13.5f, 13.33f)
                lineTo(7.0f, 10.0f)
                horizontalLineToRelative(13.0f)
                lineTo(13.5f, 13.33f)
                close()
            }
        }
        return _markAsUnread!!
    }

private var _markAsUnread: ImageVector? = null
