/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PanoramaVertical: ImageVector
    get() {
        if (_panoramaVertical != null) {
            return _panoramaVertical!!
        }
        _panoramaVertical = materialIcon(name = "TwoTone.PanoramaVertical") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.54f, 4.0f)
                curveToRelative(0.77f, 2.6f, 1.16f, 5.28f, 1.16f, 8.0f)
                curveToRelative(0.0f, 2.72f, -0.39f, 5.4f, -1.16f, 8.0f)
                horizontalLineToRelative(10.91f)
                curveToRelative(-0.77f, -2.6f, -1.16f, -5.28f, -1.16f, -8.0f)
                curveToRelative(0.0f, -2.72f, 0.39f, -5.4f, 1.16f, -8.0f)
                horizontalLineTo(6.54f)
                close()
            }
            materialPath {
                moveTo(19.94f, 21.12f)
                curveToRelative(-1.1f, -2.94f, -1.64f, -6.03f, -1.64f, -9.12f)
                curveToRelative(0.0f, -3.09f, 0.55f, -6.18f, 1.64f, -9.12f)
                curveToRelative(0.04f, -0.11f, 0.06f, -0.22f, 0.06f, -0.31f)
                curveToRelative(0.0f, -0.34f, -0.23f, -0.57f, -0.63f, -0.57f)
                horizontalLineTo(4.63f)
                curveToRelative(-0.4f, 0.0f, -0.63f, 0.23f, -0.63f, 0.57f)
                curveToRelative(0.0f, 0.1f, 0.02f, 0.2f, 0.06f, 0.31f)
                curveTo(5.16f, 5.82f, 5.71f, 8.91f, 5.71f, 12.0f)
                curveToRelative(0.0f, 3.09f, -0.55f, 6.18f, -1.64f, 9.12f)
                curveToRelative(-0.05f, 0.11f, -0.07f, 0.22f, -0.07f, 0.31f)
                curveToRelative(0.0f, 0.33f, 0.23f, 0.57f, 0.63f, 0.57f)
                horizontalLineToRelative(14.75f)
                curveToRelative(0.39f, 0.0f, 0.63f, -0.24f, 0.63f, -0.57f)
                curveToRelative(-0.01f, -0.1f, -0.03f, -0.2f, -0.07f, -0.31f)
                close()
                moveTo(17.45f, 20.0f)
                horizontalLineTo(6.54f)
                curveToRelative(0.77f, -2.6f, 1.16f, -5.28f, 1.16f, -8.0f)
                curveToRelative(0.0f, -2.72f, -0.39f, -5.4f, -1.16f, -8.0f)
                horizontalLineToRelative(10.91f)
                curveToRelative(-0.77f, 2.6f, -1.16f, 5.28f, -1.16f, 8.0f)
                curveToRelative(0.0f, 2.72f, 0.39f, 5.4f, 1.16f, 8.0f)
                close()
            }
        }
        return _panoramaVertical!!
    }

private var _panoramaVertical: ImageVector? = null
