/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Stroller: ImageVector
    get() {
        if (_stroller != null) {
            return _stroller!!
        }
        _stroller = materialIcon(name = "TwoTone.Stroller") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.0f, 5.0f)
                curveToRelative(0.29f, 0.0f, 0.58f, 0.02f, 0.86f, 0.05f)
                lineTo(9.49f, 6.66f)
                lineToRelative(-1.4f, -1.4f)
                curveTo(8.71f, 5.09f, 9.35f, 5.0f, 10.0f, 5.0f)
                moveTo(15.0f, 8.66f)
                verticalLineTo(15.0f)
                horizontalLineTo(9.6f)
                lineTo(15.0f, 8.66f)
            }
            materialPath {
                moveTo(10.0f, 5.0f)
                curveToRelative(0.29f, 0.0f, 0.58f, 0.02f, 0.86f, 0.05f)
                lineTo(9.49f, 6.66f)
                lineToRelative(-1.4f, -1.4f)
                curveTo(8.71f, 5.09f, 9.35f, 5.0f, 10.0f, 5.0f)
                moveTo(15.0f, 8.66f)
                verticalLineTo(15.0f)
                horizontalLineTo(9.6f)
                lineTo(15.0f, 8.66f)
                moveTo(18.65f, 3.0f)
                curveToRelative(-1.66f, 0.0f, -2.54f, 1.27f, -3.18f, 2.03f)
                lineToRelative(-8.8f, 10.32f)
                curveTo(6.12f, 16.0f, 6.58f, 17.0f, 7.43f, 17.0f)
                horizontalLineTo(15.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.27f)
                curveTo(17.58f, 5.59f, 17.97f, 5.0f, 18.65f, 5.0f)
                curveTo(19.42f, 5.0f, 20.0f, 5.66f, 20.0f, 6.48f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.48f)
                curveTo(22.0f, 4.56f, 20.52f, 3.0f, 18.65f, 3.0f)
                lineTo(18.65f, 3.0f)
                close()
                moveTo(10.0f, 3.0f)
                curveTo(8.03f, 3.0f, 6.21f, 3.64f, 4.72f, 4.72f)
                lineToRelative(4.89f, 4.89f)
                lineToRelative(4.7f, -5.51f)
                curveTo(13.03f, 3.4f, 11.56f, 3.0f, 10.0f, 3.0f)
                lineTo(10.0f, 3.0f)
                close()
                moveTo(16.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(17.1f, 18.0f, 16.0f, 18.0f)
                lineTo(16.0f, 18.0f)
                close()
                moveTo(6.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(7.1f, 18.0f, 6.0f, 18.0f)
                lineTo(6.0f, 18.0f)
                close()
            }
        }
        return _stroller!!
    }

private var _stroller: ImageVector? = null
