/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Dangerous: ImageVector
    get() {
        if (_dangerous != null) {
            return _dangerous!!
        }
        _dangerous = materialIcon(name = "Filled.Dangerous") {
            materialPath {
                moveTo(15.73f, 3.0f)
                horizontalLineTo(8.27f)
                lineTo(3.0f, 8.27f)
                verticalLineToRelative(7.46f)
                lineTo(8.27f, 21.0f)
                horizontalLineToRelative(7.46f)
                lineTo(21.0f, 15.73f)
                verticalLineTo(8.27f)
                lineTo(15.73f, 3.0f)
                close()
                moveTo(17.0f, 15.74f)
                lineTo(15.74f, 17.0f)
                lineTo(12.0f, 13.26f)
                lineTo(8.26f, 17.0f)
                lineTo(7.0f, 15.74f)
                lineTo(10.74f, 12.0f)
                lineTo(7.0f, 8.26f)
                lineTo(8.26f, 7.0f)
                lineTo(12.0f, 10.74f)
                lineTo(15.74f, 7.0f)
                lineTo(17.0f, 8.26f)
                lineTo(13.26f, 12.0f)
                lineTo(17.0f, 15.74f)
                close()
            }
        }
        return _dangerous!!
    }

private var _dangerous: ImageVector? = null
