/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TakeoutDining: ImageVector
    get() {
        if (_takeoutDining != null) {
            return _takeoutDining!!
        }
        _takeoutDining = materialIcon(name = "Filled.TakeoutDining") {
            materialPath(pathFillType = EvenOdd) {
                moveTo(5.26f, 11.0f)
                horizontalLineToRelative(13.48f)
                lineToRelative(-0.67f, 9.0f)
                horizontalLineTo(5.93f)
                lineTo(5.26f, 11.0f)
                close()
                moveTo(9.02f, 4.0f)
                horizontalLineToRelative(5.95f)
                lineTo(19.0f, 7.38f)
                lineToRelative(1.59f, -1.59f)
                lineTo(22.0f, 7.21f)
                lineTo(19.21f, 10.0f)
                horizontalLineTo(4.79f)
                lineTo(2.0f, 7.21f)
                lineToRelative(1.41f, -1.41f)
                lineTo(5.0f, 7.38f)
                lineTo(9.02f, 4.0f)
                close()
            }
        }
        return _takeoutDining!!
    }

private var _takeoutDining: ImageVector? = null
