/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TempleHindu: ImageVector
    get() {
        if (_templeHindu != null) {
            return _templeHindu!!
        }
        _templeHindu = materialIcon(name = "Filled.TempleHindu") {
            materialPath {
                moveTo(6.6f, 11.0f)
                lineToRelative(10.8f, 0.0f)
                lineToRelative(-0.9f, -3.0f)
                lineToRelative(-9.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 11.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-16.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 11.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, -11.0f)
                close()
            }
            materialPath {
                moveTo(15.9f, 6.0f)
                lineToRelative(-0.9f, -3.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-2.03f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 2.12f)
                lineToRelative(-0.87f, 2.88f)
                close()
            }
        }
        return _templeHindu!!
    }

private var _templeHindu: ImageVector? = null
