/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SoupKitchen: ImageVector
    get() {
        if (_soupKitchen != null) {
            return _soupKitchen!!
        }
        _soupKitchen = materialIcon(name = "Rounded.SoupKitchen") {
            materialPath {
                moveTo(6.15f, 13.5f)
                curveToRelative(-0.46f, 0.0f, -0.8f, -0.42f, -0.71f, -0.87f)
                curveTo(5.48f, 12.45f, 5.5f, 12.24f, 5.5f, 12.0f)
                curveToRelative(0.0f, -1.0f, -1.0f, -2.85f, -1.0f, -3.62f)
                curveToRelative(0.0f, -0.29f, 0.03f, -0.59f, 0.17f, -0.93f)
                curveTo(4.78f, 7.18f, 5.04f, 7.0f, 5.34f, 7.0f)
                curveToRelative(0.45f, 0.0f, 0.8f, 0.42f, 0.71f, 0.86f)
                curveTo(6.01f, 8.04f, 6.0f, 8.21f, 6.0f, 8.38f)
                curveTo(6.0f, 9.15f, 7.0f, 11.0f, 7.0f, 12.0f)
                curveToRelative(0.0f, 0.42f, -0.08f, 0.76f, -0.17f, 1.01f)
                curveTo(6.73f, 13.31f, 6.46f, 13.5f, 6.15f, 13.5f)
                close()
                moveTo(12.65f, 13.5f)
                curveToRelative(0.31f, 0.0f, 0.58f, -0.19f, 0.68f, -0.49f)
                curveToRelative(0.09f, -0.25f, 0.17f, -0.59f, 0.17f, -1.01f)
                curveToRelative(0.0f, -1.0f, -1.0f, -2.85f, -1.0f, -3.62f)
                curveToRelative(0.0f, -0.17f, 0.01f, -0.34f, 0.04f, -0.51f)
                curveTo(12.63f, 7.42f, 12.29f, 7.0f, 11.84f, 7.0f)
                curveToRelative(-0.29f, 0.0f, -0.56f, 0.18f, -0.67f, 0.45f)
                curveTo(11.03f, 7.79f, 11.0f, 8.08f, 11.0f, 8.38f)
                curveTo(11.0f, 9.15f, 12.0f, 11.0f, 12.0f, 12.0f)
                curveToRelative(0.0f, 0.24f, -0.02f, 0.45f, -0.06f, 0.63f)
                curveTo(11.85f, 13.08f, 12.19f, 13.5f, 12.65f, 13.5f)
                close()
                moveTo(9.4f, 13.5f)
                curveToRelative(0.31f, 0.0f, 0.58f, -0.19f, 0.68f, -0.49f)
                curveToRelative(0.09f, -0.25f, 0.17f, -0.59f, 0.17f, -1.01f)
                curveToRelative(0.0f, -1.0f, -1.0f, -2.85f, -1.0f, -3.62f)
                curveToRelative(0.0f, -0.17f, 0.01f, -0.34f, 0.04f, -0.51f)
                curveTo(9.38f, 7.42f, 9.04f, 7.0f, 8.59f, 7.0f)
                curveTo(8.29f, 7.0f, 8.03f, 7.18f, 7.92f, 7.45f)
                curveTo(7.78f, 7.79f, 7.75f, 8.08f, 7.75f, 8.38f)
                curveToRelative(0.0f, 0.77f, 1.0f, 2.63f, 1.0f, 3.62f)
                curveToRelative(0.0f, 0.24f, -0.02f, 0.45f, -0.06f, 0.63f)
                curveTo(8.6f, 13.08f, 8.94f, 13.5f, 9.4f, 13.5f)
                close()
                moveTo(20.46f, 6.37f)
                curveToRelative(0.57f, 0.07f, 1.08f, -0.34f, 1.12f, -0.91f)
                curveTo(21.59f, 5.28f, 21.6f, 5.12f, 21.6f, 5.0f)
                curveToRelative(0.0f, -1.65f, -1.35f, -3.0f, -3.0f, -3.0f)
                curveToRelative(-1.54f, 0.0f, -2.81f, 1.16f, -2.98f, 2.65f)
                lineTo(14.53f, 15.0f)
                horizontalLineTo(3.99f)
                curveToRelative(-0.6f, 0.0f, -1.07f, 0.54f, -0.98f, 1.14f)
                curveTo(3.54f, 19.46f, 6.39f, 22.0f, 9.75f, 22.0f)
                curveToRelative(3.48f, 0.0f, 6.34f, -2.73f, 6.71f, -6.23f)
                lineToRelative(1.15f, -10.87f)
                curveTo(17.66f, 4.39f, 18.08f, 4.0f, 18.6f, 4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.07f, -0.01f, 0.18f, -0.01f, 0.31f)
                curveTo(19.55f, 5.84f, 19.93f, 6.3f, 20.46f, 6.37f)
                lineTo(20.46f, 6.37f)
                close()
            }
        }
        return _soupKitchen!!
    }

private var _soupKitchen: ImageVector? = null
