/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoEncryptionGmailerrorred: ImageVector
    get() {
        if (_noEncryptionGmailerrorred != null) {
            return _noEncryptionGmailerrorred!!
        }
        _noEncryptionGmailerrorred = materialIcon(name = "Sharp.NoEncryptionGmailerrorred") {
            materialPath {
                moveTo(8.9f, 6.0f)
                curveToRelative(0.0f, -1.71f, 1.39f, -3.1f, 3.1f, -3.1f)
                reflectiveCurveToRelative(3.1f, 1.39f, 3.1f, 3.1f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.66f)
                lineTo(20.0f, 17.56f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(6.22f)
                curveToRelative(0.0f, -2.61f, -1.91f, -4.94f, -4.51f, -5.19f)
                curveToRelative(-2.53f, -0.25f, -4.72f, 1.41f, -5.32f, 3.7f)
                lineTo(8.9f, 6.46f)
                verticalLineTo(6.0f)
                close()
                moveTo(4.41f, 4.81f)
                lineTo(3.0f, 6.22f)
                lineTo(4.78f, 8.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(14.78f)
                lineToRelative(1.0f, 1.0f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _noEncryptionGmailerrorred!!
    }

private var _noEncryptionGmailerrorred: ImageVector? = null
