/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.bg() = mapOf(
    Strings.NavigationMenu to "Меню за навигация",
    Strings.ExposedDropdownMenu to "Падащо меню",
    Strings.CloseDrawer to "Затваряне на менюто за навигация",
    Strings.CloseSheet to "Затваряне на таблицата",
    Strings.DefaultErrorMessage to "Въведеното е невалидно",
    Strings.SliderRangeStart to "Начало на обхвата",
    Strings.SliderRangeEnd to "Край на обхвата",
    Strings.SnackbarPaneTitle to "Сигнал",
)
