/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhCN() = mapOf(
    Strings.NavigationMenu to "导航菜单",
    Strings.ExposedDropdownMenu to "下拉菜单",
    Strings.CloseDrawer to "关闭导航菜单",
    Strings.CloseSheet to "关闭工作表",
    Strings.DefaultErrorMessage to "输入无效",
    Strings.SliderRangeStart to "范围起点",
    Strings.SliderRangeEnd to "范围终点",
    Strings.SnackbarPaneTitle to "提醒",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhHK() = mapOf(
    Strings.NavigationMenu to "導覽選單",
    Strings.ExposedDropdownMenu to "下拉式選單",
    Strings.CloseDrawer to "閂導覽選單",
    Strings.CloseSheet to "閂表單",
    Strings.DefaultErrorMessage to "輸入嘅資料無效",
    Strings.SliderRangeStart to "範圍開始",
    Strings.SliderRangeEnd to "範圍結束",
    Strings.SnackbarPaneTitle to "警示",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhTW() = mapOf(
    Strings.NavigationMenu to "導覽選單",
    Strings.ExposedDropdownMenu to "下拉式選單",
    Strings.CloseDrawer to "關閉導覽選單",
    Strings.CloseSheet to "關閉功能表",
    Strings.DefaultErrorMessage to "輸入內容無效",
    Strings.SliderRangeStart to "範圍起點",
    Strings.SliderRangeEnd to "範圍終點",
    Strings.SnackbarPaneTitle to "快訊",
)
