/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ca() = mapOf(
    Strings.NavigationMenu to "Menú de navegació",
    Strings.ExposedDropdownMenu to "Menú desplegable",
    Strings.CloseDrawer to "Tanca el menú de navegació",
    Strings.CloseSheet to "Tanca el full",
    Strings.DefaultErrorMessage to "L\'entrada no és vàlida",
    Strings.SliderRangeStart to "Inici de l\'interval",
    Strings.SliderRangeEnd to "Fi de l\'interval",
)
