/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ta() = mapOf(
    Strings.NavigationMenu to "வழிசெலுத்தல் மெனு",
    Strings.ExposedDropdownMenu to "கீழ்த்தோன்றல் மெனு",
    Strings.CloseDrawer to "வழிசெலுத்தல் மெனுவை மூடும்",
    Strings.CloseSheet to "ஷீட்டை மூடும்",
    Strings.DefaultErrorMessage to "தவறான உள்ளீடு",
    Strings.SliderRangeStart to "வரம்பு தொடக்கம்",
    Strings.SliderRangeEnd to "வரம்பு முடிவு",
)
