/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sw() = mapOf(
    Strings.NavigationMenu to "Menyu ya kusogeza",
    Strings.ExposedDropdownMenu to "Menyu kunjuzi",
    Strings.CloseDrawer to "Funga menyu ya kusogeza",
    Strings.CloseSheet to "Funga laha",
    Strings.DefaultErrorMessage to "Ulichoweka si sahihi",
    Strings.SliderRangeStart to "Mwanzo wa masafa",
    Strings.SliderRangeEnd to "Mwisho wa masafa",
)
