/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.ActualJvmKt;
import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarMonth;
import androidx.compose.material3.DateInputFormat;
import androidx.compose.material3.KotlinxDatetimeCalendarModelKt;
import androidx.compose.material3.PlatformDateFormat;
import java.time.DayOfWeek;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0014\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0004H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010*\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0004H\u0016J$\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u00102\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\f\u0010,\u001a\u00020\u0004*\u00020-H\u0002J\u0014\u0010.\u001a\u00020#*\u00020/2\u0006\u00100\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Landroidx/compose/material3/KotlinxDatetimeCalendarModel;", "Landroidx/compose/material3/CalendarModel;", "()V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "systemTZ", "Lkotlinx/datetime/TimeZone;", "getSystemTZ", "()Lkotlinx/datetime/TimeZone;", "today", "Landroidx/compose/material3/CalendarDate;", "getToday", "()Landroidx/compose/material3/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/CalendarMonth;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "daysFromStartOfWeekToFirstOfMonth", "Lkotlinx/datetime/LocalDate;", "toCalendarMonth", "Lkotlinx/datetime/Instant;", "timeZone", "material3"})
@SourceDebugExtension(value={"SMAP\nKotlinxDatetimeCalendarModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxDatetimeCalendarModel.kt\nandroidx/compose/material3/KotlinxDatetimeCalendarModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class KotlinxDatetimeCalendarModel
implements CalendarModel {
    @Override
    @NotNull
    public CalendarDate getToday() {
        LocalDateTime localDate = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)this.getSystemTZ());
        return new CalendarDate(localDate.getYear(), localDate.getMonthNumber(), localDate.getDayOfMonth(), TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)localDate.getDate(), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
    }

    @Override
    public int getFirstDayOfWeek() {
        return PlatformDateFormat.INSTANCE.getFirstDayOfWeek();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.weekdayNames(ActualJvmKt.defaultLocale());
    }

    private final TimeZone getSystemTZ() {
        return TimeZone.Companion.currentSystemDefault();
    }

    @NotNull
    public final List<Pair<String, String>> weekdayNames(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PlatformDateFormat.INSTANCE.weekdayNames(locale);
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PlatformDateFormat.INSTANCE.getDateInputFormat(locale);
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        return KotlinxDatetimeCalendarModelKt.toCalendarDate(TimeZoneKt.atStartOfDayIn((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(timeInMillis), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        return this.toCalendarMonth(Instant.Companion.fromEpochMilliseconds(timeInMillis), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getMonth(date.getUtcTimeMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Instant instant = TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)new LocalDate(year, month, 1), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        return this.getMonth(instant.toEpochMilliseconds());
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return DayOfWeekKt.getIsoDayNumber((DayOfWeek)new LocalDate(date.getYear(), date.getMonth(), date.getDayOfMonth()).getDayOfWeek());
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.toCalendarMonth(TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)LocalDateJvmKt.plus((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(from.getStartUtcTimeMillis()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate(), (DatePeriod)new DatePeriod(0, addedMonthsCount, 0, 5, null)), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.plusMonths(from, -subtractedMonthsCount);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PlatformDateFormat.INSTANCE.formatWithPattern(utcTimeMillis, pattern, locale);
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return PlatformDateFormat.INSTANCE.parse(date, pattern);
    }

    private final CalendarMonth toCalendarMonth(Instant $this$toCalendarMonth, TimeZone timeZone) {
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((Instant)$this$toCalendarMonth, (TimeZone)timeZone);
        LocalDate monthStart = new LocalDate(dateTime.getYear(), dateTime.getMonth(), 1);
        return new CalendarMonth(dateTime.getYear(), dateTime.getMonthNumber(), KotlinxDatetimeCalendarModelKt.access$numberOfDays(dateTime.getMonth(), KotlinxDatetimeCalendarModelKt.access$isLeapYear(dateTime.getYear())), this.daysFromStartOfWeekToFirstOfMonth(monthStart), TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)monthStart, (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
    }

    private final int daysFromStartOfWeekToFirstOfMonth(LocalDate $this$daysFromStartOfWeekToFirstOfMonth) {
        int it = DayOfWeekKt.getIsoDayNumber((DayOfWeek)$this$daysFromStartOfWeekToFirstOfMonth.getDayOfWeek()) - this.getFirstDayOfWeek();
        boolean bl = false;
        return it > 0 ? it : 7 + it;
    }
}

