/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarModelKt;
import androidx.compose.material3.CalendarMonth;
import androidx.compose.material3.DateInputFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0014\u0010\u001f\u001a\u00020 2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0007H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0018\u0010-\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020\u0013H\u0016J\u001a\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0002J\u0014\u00100\u001a\u00020&*\u00020\r2\u0006\u00101\u001a\u000202H\u0002J\f\u00100\u001a\u00020&*\u00020$H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR-\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Landroidx/compose/material3/LegacyCalendarModelImpl;", "Landroidx/compose/material3/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "firstDayOfWeek$delegate", "Lkotlin/Lazy;", "today", "Landroidx/compose/material3/CalendarDate;", "getToday", "()Landroidx/compose/material3/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "weekdayNames$delegate", "dayInISO8601", "day", "formatWithPattern", "utcTimeMillis", "", "pattern", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/CalendarMonth;", "firstDayCalendar", "Ljava/util/Calendar;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "toString", "toCalendar", "timeZone", "Ljava/util/TimeZone;", "Companion", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/LegacyCalendarModelImpl\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,247:1\n69#2,6:248\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/LegacyCalendarModelImpl\n*L\n63#1:248,6\n*E\n"})
public final class LegacyCalendarModelImpl
extends CalendarModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy firstDayOfWeek$delegate;
    @NotNull
    private final Lazy weekdayNames$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final TimeZone utcTimeZone;

    public LegacyCalendarModelImpl(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(locale);
        this.firstDayOfWeek$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this, locale){
            final /* synthetic */ LegacyCalendarModelImpl this$0;
            final /* synthetic */ Locale $locale;
            {
                this.this$0 = $receiver;
                this.$locale = $locale;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return LegacyCalendarModelImpl.access$dayInISO8601(this.this$0, Calendar.getInstance(this.$locale).getFirstDayOfWeek());
            }
        }));
        this.weekdayNames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Pair<? extends String, ? extends String>>>(this){
            final /* synthetic */ LegacyCalendarModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Pair<String, String>> invoke() {
                return LegacyCalendarModelImpl.access$weekdayNames(this.this$0);
            }
        }));
    }

    @Override
    @NotNull
    public CalendarDate getToday() {
        Calendar systemCalendar = Calendar.getInstance();
        systemCalendar.set(11, 0);
        systemCalendar.set(12, 0);
        systemCalendar.set(13, 0);
        systemCalendar.set(14, 0);
        int utcOffset = systemCalendar.get(15) + systemCalendar.get(16);
        return new CalendarDate(systemCalendar.get(1), systemCalendar.get(2) + 1, systemCalendar.get(5), systemCalendar.getTimeInMillis() + (long)utcOffset);
    }

    @Override
    public int getFirstDayOfWeek() {
        Lazy lazy = this.firstDayOfWeek$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        Lazy lazy = this.weekdayNames$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> weekdayNames() {
        List list;
        List $this$weekdayNames_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] weekdays = new DateFormatSymbols(this.getLocale()).getWeekdays();
        String[] shortWeekdays = new DateFormatSymbols(this.getLocale()).getShortWeekdays();
        Intrinsics.checkNotNull((Object)weekdays);
        List $this$fastForEachIndexed$iv = ArraysKt.drop((Object[])weekdays, (int)2);
        boolean $i$f$fastForEachIndexed = false;
        int index$iv = 0;
        int n = $this$fastForEachIndexed$iv.size();
        while (index$iv < n) {
            void day;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            String string = (String)item$iv;
            int index = index$iv++;
            boolean bl2 = false;
            $this$weekdayNames_u24lambda_u241.add(new Pair((Object)day, (Object)shortWeekdays[index + 2]));
        }
        $this$weekdayNames_u24lambda_u241.add(new Pair(weekdays[1], (Object)shortWeekdays[1]));
        return CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        Intrinsics.checkNotNull((Object)dateFormat, (String)"null cannot be cast to non-null type java.text.SimpleDateFormat");
        String string = ((SimpleDateFormat)dateFormat).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPattern(...)");
        return CalendarModelKt.datePatternAsInputFormat(string);
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis(timeInMillis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.getTimeInMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.setTimeInMillis(timeInMillis);
        firstDayCalendar.set(5, 1);
        firstDayCalendar.set(11, 0);
        firstDayCalendar.set(12, 0);
        firstDayCalendar.set(13, 0);
        firstDayCalendar.set(14, 0);
        Intrinsics.checkNotNull((Object)firstDayCalendar);
        return this.getMonth(firstDayCalendar);
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getMonth(date.getYear(), date.getMonth());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.clear();
        firstDayCalendar.set(1, year);
        firstDayCalendar.set(2, month - 1);
        firstDayCalendar.set(5, 1);
        Intrinsics.checkNotNull((Object)firstDayCalendar);
        return this.getMonth(firstDayCalendar);
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault(...)");
        return this.dayInISO8601(this.toCalendar(date, timeZone).get(7));
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (addedMonthsCount <= 0) {
            return from;
        }
        Calendar laterMonth = this.toCalendar(from);
        laterMonth.add(2, addedMonthsCount);
        return this.getMonth(laterMonth);
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (subtractedMonthsCount <= 0) {
            return from;
        }
        Calendar earlierMonth = this.toCalendar(from);
        earlierMonth.add(2, -subtractedMonthsCount);
        return this.getMonth(earlierMonth);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return Companion.formatWithPattern(utcTimeMillis, pattern, locale, this.getFormatterCache$material3());
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        CalendarDate calendarDate;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(utcTimeZone);
        dateFormat.setLenient(false);
        try {
            Date date2 = dateFormat.parse(date);
            if (date2 == null) {
                return null;
            }
            Date parsedDate = date2;
            Calendar calendar = Calendar.getInstance(utcTimeZone);
            calendar.setTime(parsedDate);
            calendarDate = new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.getTimeInMillis());
        }
        catch (ParseException pe) {
            calendarDate = null;
        }
        return calendarDate;
    }

    @NotNull
    public String toString() {
        return "LegacyCalendarModel";
    }

    private final int dayInISO8601(int day) {
        int shiftedDay = (day + 6) % 7;
        if (shiftedDay == 0) {
            return 7;
        }
        return shiftedDay;
    }

    private final CalendarMonth getMonth(Calendar firstDayCalendar) {
        int difference = this.dayInISO8601(firstDayCalendar.get(7)) - this.getFirstDayOfWeek();
        int daysFromStartOfWeekToFirstOfMonth = difference < 0 ? difference + 7 : difference;
        return new CalendarMonth(firstDayCalendar.get(1), firstDayCalendar.get(2) + 1, firstDayCalendar.getActualMaximum(5), daysFromStartOfWeekToFirstOfMonth, firstDayCalendar.getTimeInMillis());
    }

    private final Calendar toCalendar(CalendarMonth $this$toCalendar) {
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis($this$toCalendar.getStartUtcTimeMillis());
        Intrinsics.checkNotNull((Object)calendar);
        return calendar;
    }

    private final Calendar toCalendar(CalendarDate $this$toCalendar, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(1, $this$toCalendar.getYear());
        calendar.set(2, $this$toCalendar.getMonth() - 1);
        calendar.set(5, $this$toCalendar.getDayOfMonth());
        Intrinsics.checkNotNull((Object)calendar);
        return calendar;
    }

    public static final /* synthetic */ int access$dayInISO8601(LegacyCalendarModelImpl $this, int day) {
        return $this.dayInISO8601(day);
    }

    public static final /* synthetic */ List access$weekdayNames(LegacyCalendarModelImpl $this) {
        return $this.weekdayNames();
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(...)");
        utcTimeZone = timeZone;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Landroidx/compose/material3/LegacyCalendarModelImpl$Companion;", "", "()V", "utcTimeZone", "Ljava/util/TimeZone;", "getUtcTimeZone$material3", "()Ljava/util/TimeZone;", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "cache", "", "getCachedSimpleDateFormat", "Ljava/text/SimpleDateFormat;", "material3"})
    @SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/LegacyCalendarModelImpl$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,247:1\n372#2,7:248\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/LegacyCalendarModelImpl$Companion\n*L\n199#1:248,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale, @NotNull Map<String, Object> cache) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter(cache, (String)"cache");
            SimpleDateFormat dateFormat = this.getCachedSimpleDateFormat(pattern, locale, cache);
            Calendar calendar = Calendar.getInstance(this.getUtcTimeZone$material3());
            calendar.setTimeInMillis(utcTimeMillis);
            String string = dateFormat.format(calendar.getTimeInMillis());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final TimeZone getUtcTimeZone$material3() {
            return utcTimeZone;
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleDateFormat getCachedSimpleDateFormat(String pattern, Locale locale, Map<String, Object> cache) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, Object> map2 = cache;
            String key$iv = pattern + locale.toLanguageTag();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, locale);
                dateFormat.setTimeZone(Companion.getUtcTimeZone$material3());
                SimpleDateFormat answer$iv = dateFormat;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (SimpleDateFormat)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

