/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.DateInputFormat;
import androidx.compose.material3.LegacyCalendarModelImpl;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/compose/material3/PlatformDateFormat;", "", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "delegate", "Landroidx/compose/material3/LegacyCalendarModelImpl;", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "formatWithSkeleton", "skeleton", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "is24HourFormat", "", "parse", "Landroidx/compose/material3/CalendarDate;", "date", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformDateFormat.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformDateFormat.desktop.kt\nandroidx/compose/material3/PlatformDateFormat\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,98:1\n11065#2:99\n11400#2,3:100\n*S KotlinDebug\n*F\n+ 1 PlatformDateFormat.desktop.kt\nandroidx/compose/material3/PlatformDateFormat\n*L\n75#1:99\n75#1:100,3\n*E\n"})
public final class PlatformDateFormat {
    @NotNull
    private final Locale locale;
    @NotNull
    private final LegacyCalendarModelImpl delegate;
    public static final int $stable = 8;

    public PlatformDateFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
        this.delegate = new LegacyCalendarModelImpl(this.locale);
    }

    public final int getFirstDayOfWeek() {
        return this.delegate.getFirstDayOfWeek();
    }

    @NotNull
    public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.delegate.formatWithPattern(utcTimeMillis, pattern, this.locale);
    }

    @NotNull
    public final String formatWithSkeleton(long utcTimeMillis, @NotNull String skeleton) {
        String string;
        Intrinsics.checkNotNullParameter((Object)skeleton, (String)"skeleton");
        switch (skeleton) {
            case "yMMMM": {
                string = "MMMM yyyy";
                break;
            }
            case "yMMMd": {
                string = "MMM d, yyyy";
                break;
            }
            case "yMMMMEEEEd": {
                string = "EEEE, MMMM d, yyyy";
                break;
            }
            default: {
                string = skeleton;
            }
        }
        String pattern = string;
        return this.formatWithPattern(utcTimeMillis, pattern);
    }

    @Nullable
    public final CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.delegate.parse(date, pattern);
    }

    @NotNull
    public final DateInputFormat getDateInputFormat() {
        return this.delegate.getDateInputFormat(this.locale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, String>> getWeekdayNames() {
        void $this$mapTo$iv$iv;
        DayOfWeek[] $this$map$iv = DayOfWeek.values();
        boolean $i$f$map = false;
        DayOfWeek[] dayOfWeekArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getDisplayName(TextStyle.FULL, this.locale), (Object)it.getDisplayName(TextStyle.NARROW, this.locale)));
        }
        return (List)destination$iv$iv;
    }

    public final boolean is24HourFormat() {
        DateFormat dateFormat = DateFormat.getTimeInstance(1, this.locale);
        if (!(dateFormat instanceof SimpleDateFormat)) {
            return false;
        }
        String string = ((SimpleDateFormat)dateFormat).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPattern(...)");
        return StringsKt.contains$default((CharSequence)string, (char)'H', (boolean)false, (int)2, null);
    }
}

